/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PersonnelSalaryRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(PersonnelSalaryRegister.class);
    @Autowired(required=false)
    private PromotersVoService promotersVoService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public String getVariableCode() {
        return "personnelSalary";
    }

    public String getVariableName() {
        return "\u4eba\u5458\u5de5\u8d44(\u5782\u76f4)";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        String personCode = calculateDto.getPersonCode();
        Validate.notBlank((CharSequence)personCode, (String)"\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        PromotersVo promotersVo = this.promotersVoService.findByCode(personCode);
        Validate.notNull((Object)promotersVo, (String)"\u6839\u636e\u4eba\u5458\u7f16\u7801[%s]\u672a\u67e5\u627e\u5230\u4fc3\u9500\u4eba\u5458!", (Object[])new Object[]{personCode});
        Validate.notBlank((CharSequence)promotersVo.getOutZwCode(), (String)"\u6839\u636e\u4eba\u5458\u7f16\u7801[%s]\u67e5\u627e\u5230\u7684\u4fc3\u9500\u4eba\u5458\u5916\u90e8\u667a\u7f51\u7f16\u7801\u4e3a\u7a7a!", (Object[])new Object[]{personCode});
        String outZwCode = promotersVo.getOutZwCode();
        AuditExecuteIndicatorDto indicatorDto = new AuditExecuteIndicatorDto();
        indicatorDto.setIndicatorName("personnelSalary");
        indicatorDto.setPersonCode(outZwCode);
        indicatorDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        indicatorDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        indicatorDto.setYearAndMonth(DateUtil.strToDate((String)DateUtil.dateToStr((Date)calculateDto.getEndTimeOrDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM), (SimpleDateFormat)DateUtil.date_yyyy_MM));
        log.error("\u67e5\u8be2\u4eba\u5458\u5de5\u8d44\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)indicatorDto));
        List byCode = this.auditExecuteIndicatorService.getPersonnelWage(indicatorDto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1);
        if (CollectionUtils.isEmpty((Collection)byCode)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), ((AuditExecuteIndicatorVo)byCode.get(0)).getIndicatorValue());
        return resultMap;
    }
}

