/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.returns.order.sdk.dto.ReturnOrderDto;
import com.biz.crm.kms.business.invoice.returns.order.sdk.service.ReturnOrderVoService;
import com.biz.crm.kms.business.invoice.returns.order.sdk.vo.ReturnOrderVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReturnTaxIncluded
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(ReturnTaxIncluded.class);
    @Autowired(required=false)
    ReturnOrderVoService returnOrderVoService;
    @Autowired(required=false)
    ProductVoService productVoService;
    @Autowired(required=false)
    TerminalVoService terminalVoService;

    public String getVariableCode() {
        return "returnTaxIncluded";
    }

    public String getVariableName() {
        return "\u9000\u8d27\u542b\u7a0e\u91d1\u989d\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.CONTRACT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getStartTimeOrDate(), (String)"\u9000\u8d27\u542b\u7a0e\u91d1\u989d\uff0c\u672a\u4f20\u5165\u5f00\u59cb\u65e5\u671f", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u9000\u8d27\u542b\u7a0e\u91d1\u989d\uff0c\u672a\u4f20\u5165\u7ed3\u675f\u65e5\u671f", (Object[])new Object[0]);
        ReturnOrderDto dto = new ReturnOrderDto();
        dto.setStartDate(DateUtil.dateToStr((Date)calculateDto.getStartTimeOrDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd));
        dto.setEndDate(DateUtil.dateToStr((Date)calculateDto.getEndTimeOrDate(), (SimpleDateFormat)DateUtil.date_yyyy_MM_dd));
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setProductCodeList((List)Lists.newArrayList((Object[])new String[]{calculateDto.getProductCode()}));
        } else if (CollectionUtils.isNotEmpty((Collection)calculateDto.getProductCodeSetForVertical())) {
            dto.setProductCodeList((List)Lists.newArrayList((Iterable)calculateDto.getProductCodeSetForVertical()));
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            ProductQueryDto productQueryDto = new ProductQueryDto();
            if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
                productQueryDto.setProductLevelCode(calculateDto.getItemCode());
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
                productQueryDto.setProductCategoryCode(calculateDto.getCategoryCode());
            } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
                productQueryDto.setProductBrandCode(calculateDto.getBrandCode());
            } else {
                throw new RuntimeException("\u9000\u8d27\u542b\u7a0e\u91d1\u989d\uff0c\u672a\u5f55\u5165\u4ea7\u54c1\u6216\u8005\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f");
            }
            List productVoList = this.productVoService.findByProductQueryDto(productQueryDto);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)productVoList), (String)"\u9000\u8d27\u542b\u7a0e\u91d1\u989d\uff0c\u6839\u636e\u5f53\u524d\u6761\u4ef6\u672a\u627e\u5230\u4efb\u4f55\u4ea7\u54c1", (Object[])new Object[0]);
            Set productCodeSet = productVoList.stream().map(ProductVo::getProductCode).collect(Collectors.toSet());
            calculateDto.setProductCodeSetForVertical(productCodeSet);
            dto.setProductCodeList((List)Lists.newArrayList(productCodeSet));
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            dto.setTerminalCodeList((List)Lists.newArrayList((Object[])new String[]{calculateDto.getStoresCode()}));
        } else if (CollectionUtils.isNotEmpty((Collection)calculateDto.getTerminalCodeSetForVertical())) {
            dto.setTerminalCodeList((List)Lists.newArrayList((Iterable)calculateDto.getTerminalCodeSetForVertical()));
        } else {
            Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)calculateDto.getActivityOrgCode(), (String)"\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            TerminalSearchDto terminalSearchDto = new TerminalSearchDto();
            terminalSearchDto.setCustomerRetailerCode(calculateDto.getRetailBusinessmanCode());
            terminalSearchDto.setRegionCode(calculateDto.getActivityOrgCode());
            terminalSearchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            List terminalVoList = this.terminalVoService.findByTerminalSearchDto(terminalSearchDto);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)terminalVoList), (String)"\u9000\u8d27\u542b\u7a0e\u91d1\u989d\uff0c\u6839\u636e\u5f53\u524d\u6761\u4ef6\u672a\u627e\u5230\u4efb\u4f55\u95e8\u5e97", (Object[])new Object[0]);
            Set terminalCodeSet = terminalVoList.stream().map(TerminalVo::getTerminalCode).collect(Collectors.toSet());
            calculateDto.setTerminalCodeSetForVertical(terminalCodeSet);
            dto.setTerminalCodeList((List)Lists.newArrayList(terminalCodeSet));
        }
        dto.setExcludeProductCodeList(calculateDto.getExcludeProductCodeList());
        ReturnOrderVo result = this.returnOrderVoService.findAmountForVariable(dto);
        log.error("\u9000\u8d27\u542b\u7a0e\u91d1\u989dfeign\u8fd4\u56de:{}", (Object)result);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(4);
        resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
        if (Objects.nonNull(result) && Objects.nonNull(result.getReturnAmount())) {
            resultMap.put(this.getVariableCode(), result.getReturnAmount());
        }
        return resultMap;
    }
}

