/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalAllProductAfterDiscountDeliveryYieldRateRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VerticalAllProductAfterDiscountDeliveryYieldRateRegister.class);
    @Autowired(required=false)
    private SalesPerformanceService salesPerformanceService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;

    public String getVariableCode() {
        return "verticalAllProductAfterDiscountDeliveryYieldRate";
    }

    public String getVariableName() {
        return "\u5168\u54c1\u6298\u540e\u51fa\u5e93\u8fbe\u6210\u7387\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        BigDecimal deliveryDiscountSalesAmount;
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanCode(), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanName(), (String)"\u96f6\u552e\u5546\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getActivityOrgCode(), (String)"\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getActivityOrgName(), (String)"\u533a\u57df\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesPerformanceDto dto = new SalesPerformanceDto();
        String yearMonthLy = calculateDto.getYearMonthLy();
        dto.setSalesMonth(yearMonthLy.replaceAll("-", ""));
        dto.setRetailer(calculateDto.getRetailBusinessmanName());
        dto.setRegion(calculateDto.getActivityOrgName());
        SalesPerformanceVo salesPerformanceVo = this.salesPerformanceService.findSalesAmountAndOutNumber(dto);
        BigDecimal verticalRealitySalesAmount = Objects.nonNull(salesPerformanceVo) && Objects.nonNull(salesPerformanceVo.getWarehsOutDiscountAmt()) ? salesPerformanceVo.getWarehsOutDiscountAmt() : BigDecimal.ZERO;
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(4);
        Validate.notBlank((CharSequence)calculateDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)calculateDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getEndTimeOrDate(), (String)"\u7ed3\u675f\u65f6\u95f4/\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesGoalDto salesGoalDto = new SalesGoalDto();
        salesGoalDto.setYearMonthLy(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)calculateDto.getEndTimeOrDate()));
        salesGoalDto.setBusinessFormatCode(calculateDto.getBusinessFormatCode());
        salesGoalDto.setBusinessUnitCode(calculateDto.getBusinessUnitCode());
        salesGoalDto.setSystemCode(calculateDto.getRetailBusinessmanCode());
        salesGoalDto.setRegionCode(calculateDto.getActivityOrgCode());
        salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.ACHIEVEMENT.getCode());
        SalesGoalSumVo salesGoalSumVo = this.salesGoalService.findDiscountAfterAndDeliveryQuantity(salesGoalDto);
        BigDecimal bigDecimal = deliveryDiscountSalesAmount = Objects.nonNull(salesGoalSumVo) && Objects.nonNull(salesGoalSumVo.getDeliveryDiscountSalesAmount()) ? salesGoalSumVo.getDeliveryDiscountSalesAmount() : BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(deliveryDiscountSalesAmount) == 0) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), verticalRealitySalesAmount.divide(deliveryDiscountSalesAmount, 4, RoundingMode.HALF_UP));
        return resultMap;
    }
}

