/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalBillingCoefficientRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VerticalBillingCoefficientRegister.class);
    @Autowired(required=false)
    private SalesPerformanceService salesPerformanceService;

    public String getVariableCode() {
        return "verticalBillingCoefficient";
    }

    public String getVariableName() {
        return "\u5f00\u5355\u7cfb\u6570\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        BigDecimal allOrderRuleAmtInRebate;
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesPerformanceDto dto = new SalesPerformanceDto();
        String yearMonth = calculateDto.getYearMonthLy().replaceAll("-", "");
        dto.setSalesMonth(yearMonth);
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setMaterialCode(calculateDto.getProductCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            dto.setCategoryCode(calculateDto.getItemCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            dto.setClassify(calculateDto.getCategoryCode());
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            dto.setBrand(calculateDto.getBrandCode());
        } else {
            throw new RuntimeException("\u5f00\u5355\u7cfb\u6570\uff08\u5782\u76f4\uff09\uff0c\u672a\u5f55\u5165\u4ea7\u54c1\u6216\u8005\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode())) {
            dto.setShipToparty(calculateDto.getStoresCode());
        } else {
            Validate.notBlank((CharSequence)calculateDto.getRetailBusinessmanName(), (String)"\u96f6\u552e\u5546\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)calculateDto.getActivityOrgName(), (String)"\u533a\u57df\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            dto.setRetailer(calculateDto.getRetailBusinessmanName());
            dto.setRegion(calculateDto.getActivityOrgName());
        }
        SalesPerformanceVo allSalesPerformanceVo = this.salesPerformanceService.findSalesAmountAndOutNumber(dto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(4);
        BigDecimal bigDecimal = allOrderRuleAmtInRebate = Objects.nonNull(allSalesPerformanceVo) && Objects.nonNull(allSalesPerformanceVo.getOrderRuleAmtInRebate()) ? allSalesPerformanceVo.getOrderRuleAmtInRebate() : BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(allOrderRuleAmtInRebate) == 0) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        dto.setStartDate(yearMonth + "01");
        dto.setEndDate(yearMonth + "20");
        SalesPerformanceVo salesPerformanceVo = this.salesPerformanceService.findSalesAmountAndOutNumber(dto);
        BigDecimal orderRuleAmtInRebate = Objects.nonNull(salesPerformanceVo) && Objects.nonNull(salesPerformanceVo.getOrderRuleAmtInRebate()) ? salesPerformanceVo.getOrderRuleAmtInRebate() : BigDecimal.ZERO;
        BigDecimal verticalBillingCoefficient = orderRuleAmtInRebate.divide(allOrderRuleAmtInRebate, 4, RoundingMode.HALF_UP);
        resultMap.put(this.getVariableCode(), verticalBillingCoefficient);
        return resultMap;
    }
}

