/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalOutStorageAchieve
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VerticalOutStorageAchieve.class);
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    private static final String MDM_CUSTOMIZE_ORG = "MDM_CUSTOMIZE_ORG";

    public String getVariableCode() {
        return "verticalOutStorageAchieve";
    }

    public String getVariableName() {
        return "\u533a\u57df\u51fa\u5e93\u8fbe\u6210\u7387";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        list.add(VariableFunctionEnum.CONTRACT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getActivityOrgCode(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesPerformanceDto dto = new SalesPerformanceDto();
        DictDataVo dictDataVo = this.dictDataVoService.findByDictTypeCodeAndDictCode(MDM_CUSTOMIZE_ORG, calculateDto.getActivityOrgCode());
        dto.setRegion(dictDataVo.getDictValue());
        dto.setSalesMonth(calculateDto.getYearMonthLy().replace("-", ""));
        BigDecimal salesAmount = this.salesPerformanceVoService.findSalesAmount(dto);
        SalesGoalDto dto2 = new SalesGoalDto();
        dto2.setRegionCode(calculateDto.getActivityOrgCode());
        dto2.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto2.setYearSalesTypeCode(YearSalesTypeEnum.ACHIEVEMENT.getCode());
        dto2.setYearMonthLyVariable(calculateDto.getYearMonthLy());
        BigDecimal discountAfter = this.salesGoalService.findDiscountAfter(dto2);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), discountAfter.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : salesAmount.divide(discountAfter, 4, 4));
        return resultMap;
    }
}

