/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.sales.goal.local.service.SalesPerformanceService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalRealitySalesNumberRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VerticalRealitySalesNumberRegister.class);
    @Autowired(required=false)
    private SalesPerformanceService salesPerformanceService;

    public String getVariableCode() {
        return "verticalRealitySalesNumber";
    }

    public String getVariableName() {
        return "\u5782\u76f4\u5b9e\u9645\u9500\u552e\u91cf\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        functionList.add(VariableFunctionEnum.CONTRACT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesPerformanceDto dto = new SalesPerformanceDto();
        dto.setSalesMonth(calculateDto.getYearMonthLy().replaceAll("-", ""));
        dto.setMaterialCode(calculateDto.getProductCode());
        dto.setShipToparty(calculateDto.getStoresCode());
        dto.setCategoryCode(calculateDto.getItemCode());
        dto.setClassify(calculateDto.getCategoryCode());
        dto.setBrand(calculateDto.getBrandCode());
        dto.setRegion(calculateDto.getSaleRegion());
        dto.setRetailer(calculateDto.getRetailBusinessmanName());
        dto.setExcludeProductCodeList(calculateDto.getExcludeProductCodeList());
        SalesPerformanceVo salesPerformanceVo = this.salesPerformanceService.findSalesAmountAndOutNumber(dto);
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), salesPerformanceVo.getWarehsOutQty());
        return resultMap;
    }
}

