/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerticalRegionGradientRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VerticalRegionGradientRegister.class);
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    private String MDM_CUSTOMIZE_ORG = "MDM_CUSTOMIZE_ORG";

    public String getVariableCode() {
        return "verticalRegionGradient";
    }

    public String getVariableName() {
        return "\u533a\u57df\u68af\u5ea6\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList list = Lists.newArrayList();
        list.add(VariableFunctionEnum.AUDIT);
        return list;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        BigDecimal valueBigDecimal;
        HashMap resultMap = Maps.newHashMap();
        String activityOrgCode = calculateDto.getActivityOrgCode();
        if (StringUtils.isEmpty((CharSequence)activityOrgCode)) {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{this.MDM_CUSTOMIZE_ORG}));
        HashMap keyToValueMap = Maps.newHashMap();
        mapDict.forEach((key, value) -> value.forEach(dictVo -> {
            String keyCode = dictVo.getDictCode();
            Map extendMap = dictVo.getExtendMap();
            String orgGradient = extendMap == null ? null : (String)extendMap.get("org_gradient");
            keyToValueMap.put(keyCode, orgGradient);
        }));
        if (keyToValueMap.containsKey(activityOrgCode)) {
            String valueStr = (String)keyToValueMap.get(activityOrgCode);
            try {
                valueBigDecimal = new BigDecimal(valueStr);
            }
            catch (Exception e) {
                valueBigDecimal = BigDecimal.ZERO;
            }
        } else {
            resultMap.put(this.getVariableCode(), BigDecimal.ZERO);
            return resultMap;
        }
        resultMap.put(this.getVariableCode(), valueBigDecimal);
        return resultMap;
    }
}

