/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VerticalSingleApplicationFeeRegister
implements FormulaVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(VerticalSingleApplicationFeeRegister.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailVoService auditFeeDiffTrackDetailVoService;

    public String getVariableCode() {
        return "verticalSingleApplicationFee";
    }

    public String getVariableName() {
        return "\u5355\u4ef6\u7533\u8bf7\u8d39\u7528\uff08\u5782\u76f4\uff09";
    }

    public Integer getSort() {
        return 1;
    }

    public List<VariableFunctionEnum> getFunctionEnumList() {
        ArrayList functionList = Lists.newArrayList();
        functionList.add(VariableFunctionEnum.AUDIT);
        return functionList;
    }

    public Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto) {
        Validate.notNull((Object)calculateDto.getDetailPlanItemCode(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal amount = BigDecimal.ZERO;
        if (Boolean.TRUE.equals(calculateDto.getIsDiffTrack())) {
            AuditFeeDiffTrackDetailVo detailVo;
            List detailVos = this.auditFeeDiffTrackDetailVoService.findByDetailCodes((List)Lists.newArrayList((Object[])new String[]{calculateDto.getDetailPlanItemCode()}));
            AuditFeeDiffTrackDetailVo auditFeeDiffTrackDetailVo = detailVo = CollectionUtils.isEmpty((Collection)detailVos) ? null : (AuditFeeDiffTrackDetailVo)detailVos.get(0);
            if (detailVo != null) {
                amount = Optional.ofNullable(detailVo.getSingleApplicationFee()).orElse(BigDecimal.ZERO);
            }
        } else {
            ActivityDetailPlanItemVo detailPlanItemVo = this.activityDetailPlanItemService.findDetailPlanItemByItemCode(calculateDto.getDetailPlanItemCode());
            if (detailPlanItemVo != null) {
                amount = Optional.ofNullable(detailPlanItemVo.getSingleApplicationFee()).orElse(BigDecimal.ZERO);
            }
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        resultMap.put(this.getVariableCode(), amount);
        return resultMap;
    }
}

