/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.register.vertical.common;

import com.biz.crm.kms.business.invoice.statement.sdk.dto.InvoiceStatementVariableDto;
import com.biz.crm.kms.business.invoice.statement.sdk.enums.DocumentType;
import com.biz.crm.kms.business.invoice.statement.sdk.service.InvoiceStatementVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VariableKmsSettlementService {
    @Autowired(required=false)
    private InvoiceStatementVoService invoiceStatementVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public BigDecimal getValue(DocumentType documentType, String valueName, CalculateDto calculateDto) {
        List list;
        Validate.notBlank((CharSequence)calculateDto.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)documentType, (String)"\u672a\u6307\u5b9a\u8981\u67e5\u8be2\u7684\u5355\u636e\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)calculateDto.getCustomerErpCode()) || StringUtils.isNotEmpty((CharSequence)calculateDto.getStoresCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237MDG\u7f16\u7801\u548c\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String productLevelCode = null;
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getItemCode())) {
            productLevelCode = calculateDto.getItemCode();
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getCategoryCode())) {
            productLevelCode = calculateDto.getCategoryCode();
        } else if (StringUtils.isNotEmpty((CharSequence)calculateDto.getBrandCode())) {
            productLevelCode = calculateDto.getBrandCode();
        }
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode()) || StringUtils.isNotEmpty((CharSequence)productLevelCode) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7f16\u7801\u3001\u4ea7\u54c1\u5c42\u7ea7\u5168\u90e8\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        InvoiceStatementVariableDto dto = new InvoiceStatementVariableDto();
        if (StringUtils.isNotEmpty((CharSequence)calculateDto.getProductCode())) {
            dto.setProductCodeList(Arrays.asList(calculateDto.getProductCode().split(",")));
        } else if (StringUtils.isNotEmpty((CharSequence)productLevelCode) && !CollectionUtils.isEmpty((Collection)(list = this.productVoService.findByProductLevelCodes((List)Lists.newArrayList((Object[])new String[]{productLevelCode}))))) {
            dto.setProductCodeList(list.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getProductCode())).map(ProductVo::getProductCode).collect(Collectors.toList()));
        }
        Validate.notEmpty((Collection)dto.getProductCodeList(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e3a\u83b7\u53d6\u5230\u4ea7\u54c1\u6570\u636e\uff01", (Object[])new Object[0]);
        dto.setSoldToPartyCode(calculateDto.getCustomerErpCode());
        dto.setDeliveryPartyCode(calculateDto.getStoresCode());
        dto.setDocumentType(documentType.getCode());
        dto.setYearMonthStr(calculateDto.getYearMonthLy());
        Map map = this.invoiceStatementVoService.findForVariable(dto);
        if (Objects.nonNull(map)) {
            return map.getOrDefault(valueName, BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }
}

