/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.mapper.SourceCustomVariableMapper;
import com.biz.crm.tpm.business.variable.sdk.enums.CustomVariableSourceEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SourceCustomVariableRepository
extends ServiceImpl<SourceCustomVariableMapper, SourceCustomVariableEntity> {
    @Autowired(required=false)
    private SourceCustomVariableMapper sourceCustomVariableMapper;

    public List<SourceCustomVariableEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public List<SourceCustomVariableEntity> findByVariableCodes(List<String> variableCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(SourceCustomVariableEntity::getVariableCode, variableCodeList)).list();
    }

    public Integer findDuplicateCount(SourceCustomVariableEntity entity) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(StringUtils.isNotEmpty((CharSequence)entity.getId()), UuidEntity::getId, (Object)entity.getId())).and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(SourceCustomVariableEntity::getVariableCode, (Object)entity.getVariableCode())).or()).eq(SourceCustomVariableEntity::getVariableName, (Object)entity.getVariableName());
        })).count();
    }

    public List<RegisterVariableVo> findForVariableList(String name, Integer limitSize) {
        return this.sourceCustomVariableMapper.findForVariableList(name, limitSize, TenantUtils.getTenantCode());
    }

    public List<RegisterVariableVo> findAllVariableList() {
        return this.sourceCustomVariableMapper.findAllVariableList(CustomVariableSourceEnum.EXECUTOR_INDICATOR.getCode(), TenantUtils.getTenantCode());
    }

    public List<RegisterVariableVo> variableAuthList(String isConfigure, String function, String name, Integer pageSize) {
        List<RegisterVariableVo> keyIndicatorVos = this.sourceCustomVariableMapper.variableAuthList(isConfigure, function, name, pageSize, TenantUtils.getTenantCode());
        int size = keyIndicatorVos.size();
        if (size == pageSize) {
            return keyIndicatorVos;
        }
        if (!YesOrNoEnum.YES.getCode().equals(isConfigure) && VariableFunctionEnum.AUDIT.getCode().equals(function)) {
            List<RegisterVariableVo> customVos = this.sourceCustomVariableMapper.customVariableAuthList(isConfigure, function, name, pageSize - keyIndicatorVos.size(), TenantUtils.getTenantCode());
            keyIndicatorVos.addAll(customVos);
        }
        return keyIndicatorVos;
    }
}

