/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.variable.local.entity.ConVariableDetailEntity;
import com.biz.crm.tpm.business.variable.local.repository.ConVariableDetailRepository;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ConVariableDetailSdkServiceImpl
implements ConVariableDetailSdkService {
    private static final Logger log = LoggerFactory.getLogger(ConVariableDetailSdkServiceImpl.class);
    @Resource
    private ConVariableDetailRepository conVariableDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteByAuditFormulaCode(ConVariableDetailDto detailDto) {
        Assert.notNull((Object)detailDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)detailDto.getAuditFormulaCode(), (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.conVariableDetailRepository.deleteByAuditFormulaCode(detailDto.getAuditFormulaCode());
    }

    public void batchSave(List<ConVariableDetailDto> detailDto) {
        if (CollectionUtils.isEmpty(detailDto)) {
            return;
        }
        detailDto.forEach(o -> {
            o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            o.setTenantCode(TenantUtils.getTenantCode());
        });
        Collection entities = this.nebulaToolkitService.copyCollectionByBlankList(detailDto, ConVariableDetailDto.class, ConVariableDetailEntity.class, HashSet.class, ArrayList.class, new String[0]);
        this.conVariableDetailRepository.saveBatch(entities);
    }

    public List<ConVariableDetailVo> getItemDetail(ConVariableDetailDto detailDto) {
        Assert.notNull((Object)detailDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)detailDto.getAuditFormulaCode(), (String)"\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.conVariableDetailRepository.getItemDetail(detailDto);
    }

    public List<ConVariableDetailVo> findConVariableListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.conVariableDetailRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ConVariableDetailEntity::getAuditFormulaCode, codes)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ConVariableDetailEntity.class, ConVariableDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ConVariableDetailVo> findConVariableList(String formulaCode, String variableCode) {
        if (StringUtils.isEmpty((Object)formulaCode) || StringUtils.isEmpty((Object)variableCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.conVariableDetailRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(ConVariableDetailEntity::getAuditFormulaCode, (Object)formulaCode)).eq(ConVariableDetailEntity::getVariableCode, (Object)variableCode)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ConVariableDetailEntity.class, ConVariableDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

