/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.service.impl;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.repository.SourceCustomVariableRepository;
import com.biz.crm.tpm.business.variable.local.utils.SourceCustomVariableUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.dto.log.SourceCustomVariableEventDto;
import com.biz.crm.tpm.business.variable.sdk.event.SourceCustomVariableEventListener;
import com.biz.crm.tpm.business.variable.sdk.service.SourceCustomVariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.biz.crm.tpm.business.variable.sdk.vo.SourceCustomVariableVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SourceCustomVariableServiceImpl
implements SourceCustomVariableService {
    @Autowired(required=false)
    private SourceCustomVariableRepository sourceCustomVariableRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SourceCustomVariableUtil sourceCustomVariableUtil;

    public SourceCustomVariableVo findById(String id) {
        List<SourceCustomVariableEntity> entityList = this.sourceCustomVariableRepository.findByIds(Lists.newArrayList((Object[])new String[]{id}));
        Validate.notEmpty(entityList, (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return (SourceCustomVariableVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entityList.get(0), SourceCustomVariableVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void create(SourceCustomVariableDto dto) {
        this.sourceCustomVariableUtil.valCreate(dto);
        SourceCustomVariableEntity entity = (SourceCustomVariableEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SourceCustomVariableEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.sourceCustomVariableUtil.checkDuplicate(entity);
        this.sourceCustomVariableUtil.packageEntity(entity);
        this.sourceCustomVariableRepository.save((Object)entity);
        SourceCustomVariableEventDto logEventDto = new SourceCustomVariableEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = SourceCustomVariableEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SourceCustomVariableEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional
    public void update(SourceCustomVariableDto dto) {
        SourceCustomVariableVo vo = this.findById(dto.getId());
        Validate.notNull((Object)vo, (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        SourceCustomVariableEntity entity = (SourceCustomVariableEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SourceCustomVariableEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.sourceCustomVariableUtil.checkDuplicate(entity);
        this.sourceCustomVariableUtil.packageEntity(entity);
        this.sourceCustomVariableRepository.updateById((Object)entity);
        SourceCustomVariableEventDto logEventDto = new SourceCustomVariableEventDto();
        logEventDto.setOriginal(vo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = SourceCustomVariableEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SourceCustomVariableEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
        List<SourceCustomVariableEntity> list = this.sourceCustomVariableRepository.findByIds(ids);
        List enableList = list.stream().filter(e -> EnableStatusEnum.DISABLE.getCode().equals(e.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enableList)) {
            return;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SourceCustomVariableEntity.class, SourceCustomVariableVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (SourceCustomVariableEntity entity : enableList) {
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        this.sourceCustomVariableRepository.updateBatchById(enableList);
        SerializableBiConsumer & Serializable onEnable = SourceCustomVariableEventListener::onEnable;
        for (SourceCustomVariableVo vo : vos) {
            SourceCustomVariableEventDto logEventDto = new SourceCustomVariableEventDto();
            logEventDto.setOriginal(vo);
            SourceCustomVariableDto dto = (SourceCustomVariableDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, SourceCustomVariableDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SourceCustomVariableEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
        List<SourceCustomVariableEntity> list = this.sourceCustomVariableRepository.findByIds(ids);
        List disableList = list.stream().filter(e -> EnableStatusEnum.ENABLE.getCode().equals(e.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(disableList)) {
            return;
        }
        List vos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, SourceCustomVariableEntity.class, SourceCustomVariableVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (SourceCustomVariableEntity entity : disableList) {
            entity.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        }
        this.sourceCustomVariableRepository.updateBatchById(disableList);
        SerializableBiConsumer & Serializable onDisable = SourceCustomVariableEventListener::onDisable;
        for (SourceCustomVariableVo vo : vos) {
            SourceCustomVariableEventDto logEventDto = new SourceCustomVariableEventDto();
            logEventDto.setOriginal(vo);
            SourceCustomVariableDto dto = (SourceCustomVariableDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, SourceCustomVariableDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SourceCustomVariableEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    public List<RegisterVariableVo> findAllVariableList() {
        return this.sourceCustomVariableRepository.findAllVariableList();
    }
}

