/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.RulesEnactService;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.repository.SourceCustomVariableRepository;
import com.biz.crm.tpm.business.variable.local.utils.TestResultUtil;
import com.biz.crm.tpm.business.variable.local.utils.VariableUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ControlsDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaCustomVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.variable.sdk.vo.ControlsVo;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableCalTestVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class VariableServiceImpl
implements VariableService {
    private static final Logger log = LoggerFactory.getLogger(VariableServiceImpl.class);
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisterList;
    @Autowired(required=false)
    private VariableUtil variableUtil;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DimensionControlsService dimensionControlsService;
    @Resource
    private RulesEnactService rulesEnactService;
    @Resource
    private SourceCustomVariableRepository sourceCustomVariableRepository;

    public List<CalculateVo> allCalculateConditionAndExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoList, (String)"\u672a\u5339\u914d\u5230\u516c\u5f0f\u7ed3\u679c", (Object[])new Object[0]);
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateConditionAndExpression(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    public List<CalculateVo> allCalculateCondition(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoList, (String)"\u672a\u5339\u914d\u5230\u516c\u5f0f\u7ed3\u679c", (Object[])new Object[0]);
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateCondition(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    public List<CalculateVo> allCalculateExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoList, (String)"\u672a\u5339\u914d\u5230\u516c\u5f0f\u7ed3\u679c", (Object[])new Object[0]);
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateExpression(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    public List<CalculateVo> orCalculateConditionAndExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoList, (String)"\u672a\u5339\u914d\u5230\u516c\u5f0f\u7ed3\u679c", (Object[])new Object[0]);
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList);
            CalculateVo calculateVo = this.variableUtil.orCalculateConditionAndExpression(calculateDto, variableValueMap, formulaInfoList);
            if (Objects.isNull(calculateVo)) {
                calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionValue(Boolean.FALSE);
            }
            calculateVo.setVariableValueMap(variableValueMap);
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public List<CalculateVo> orCalculateCondition(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoList, (String)"\u672a\u5339\u914d\u5230\u516c\u5f0f\u7ed3\u679c", (Object[])new Object[0]);
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList);
            CalculateVo calculateVo = this.variableUtil.orCalculateCondition(calculateDto, variableValueMap, formulaInfoList);
            if (Objects.isNull(calculateVo)) {
                calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionValue(Boolean.FALSE);
            }
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public List<CalculateVo> orCalculateExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoList, (String)"\u672a\u5339\u914d\u5230\u516c\u5f0f\u7ed3\u679c", (Object[])new Object[0]);
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList);
            CalculateVo calculateVo = this.variableUtil.orCalculateExpression(calculateDto, variableValueMap, formulaInfoList);
            if (Objects.isNull(calculateVo)) {
                calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionValue(Boolean.FALSE);
            }
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public List<RegisterVariableVo> variableList(String isConfigure, String function, String name, Integer pageSize) {
        ArrayList<RegisterVariableVo> registerVariableVoList = new ArrayList<RegisterVariableVo>();
        Validate.notNull((Object)function, (String)"\u529f\u80fd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.formulaVariableRegisterList)) {
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.formulaVariableRegisterList.forEach(register -> {
                    if (register.isConfigurable().booleanValue() != isConfigure.equals(BooleanEnum.TRUE.getNumStr())) {
                        return;
                    }
                    List functionStringList = register.getFunctionStringList();
                    if (CollectionUtils.isEmpty((Collection)functionStringList) || !functionStringList.contains(function)) {
                        return;
                    }
                    RegisterVariableVo registerVariableVo = new RegisterVariableVo();
                    registerVariableVo.setCode(register.getVariableCode());
                    registerVariableVo.setName(register.getVariableName());
                    registerVariableVo.setType(String.join((CharSequence)",", register.getFunctionStringList()));
                    registerVariableVo.setSort(register.getSort());
                    registerVariableVoList.add(registerVariableVo);
                });
            } else {
                Pattern compile = Pattern.compile(name, 2);
                this.formulaVariableRegisterList.forEach(register -> {
                    Matcher matcher = compile.matcher(register.getVariableName());
                    if (matcher.find()) {
                        if (register.isConfigurable().booleanValue() != isConfigure.equals(BooleanEnum.TRUE.getNumStr())) {
                            return;
                        }
                        List functionStringList = register.getFunctionStringList();
                        if (CollectionUtils.isEmpty((Collection)functionStringList) || !functionStringList.contains(function)) {
                            return;
                        }
                        RegisterVariableVo registerVariableVo = new RegisterVariableVo();
                        registerVariableVo.setCode(register.getVariableCode());
                        registerVariableVo.setName(register.getVariableName());
                        registerVariableVo.setType(String.join((CharSequence)",", register.getFunctionStringList()));
                        registerVariableVo.setSort(register.getSort());
                        registerVariableVoList.add(registerVariableVo);
                    }
                });
            }
        }
        int currSize = registerVariableVoList.size();
        if (!isConfigure.equals(BooleanEnum.TRUE.getNumStr()) && VariableFunctionEnum.AUDIT.getCode().equals(function)) {
            if (Objects.isNull(pageSize)) {
                pageSize = 200;
            }
            if (currSize < pageSize) {
                List<RegisterVariableVo> customVariableList = this.sourceCustomVariableRepository.findForVariableList(name, pageSize - currSize);
                registerVariableVoList.addAll(customVariableList);
            }
        }
        return registerVariableVoList.stream().sorted(Comparator.comparingInt(RegisterVariableVo::getSort)).collect(Collectors.toList());
    }

    public List<RegisterVariableVo> variableAuthList(String isConfigure, String function, String name, Integer pageSize) {
        Validate.notNull((Object)function, (String)"\u529f\u80fd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.sourceCustomVariableRepository.variableAuthList(StringUtils.equals((CharSequence)BooleanEnum.TRUE.getNumStr(), (CharSequence)isConfigure) ? YesOrNoEnum.YES.getCode() : YesOrNoEnum.NO.getCode(), function, name, pageSize);
    }

    public Map<String, String> getVariableMap(String function, List<String> variableCodeList) {
        ArrayList variableVos = new ArrayList();
        this.formulaVariableRegisterList.forEach(register -> {
            List functionStringList = register.getFunctionStringList();
            if (CollectionUtils.isEmpty((Collection)functionStringList) || !functionStringList.contains(function)) {
                return;
            }
            if (!CollectionUtils.isEmpty((Collection)variableCodeList) && !variableCodeList.contains(register.getVariableCode())) {
                return;
            }
            variableCodeList.remove(register.getVariableCode());
            RegisterVariableVo registerVariableVo = new RegisterVariableVo();
            registerVariableVo.setCode(register.getVariableCode());
            registerVariableVo.setName(register.getVariableName());
            registerVariableVo.setSort(register.getSort());
            variableVos.add(registerVariableVo);
        });
        Map<String, String> result = variableVos.stream().collect(Collectors.toMap(RegisterVariableVo::getCode, RegisterVariableVo::getName, (v1, v2) -> v2));
        if (!CollectionUtils.isEmpty(variableCodeList)) {
            List<SourceCustomVariableEntity> customVariableList = this.sourceCustomVariableRepository.findByVariableCodes(variableCodeList);
            Map<String, String> map = customVariableList.stream().collect(Collectors.toMap(SourceCustomVariableEntity::getVariableCode, SourceCustomVariableEntity::getVariableName, (v1, v2) -> v2));
            result.putAll(map);
        }
        return result;
    }

    public VariableCalTestVo calTest(CalculateDto dto) {
        List<CalculateVo> calculateVos = this.orCalculateConditionAndExpression(Lists.newArrayList((Object[])new CalculateDto[]{dto}));
        ArrayList<String> variableCodeList = new ArrayList<String>();
        for (CalculateVo calculateVo : calculateVos) {
            if (!Objects.nonNull(calculateVo.getVariableValueMap())) continue;
            variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
        }
        Map<String, String> variableNameMap = this.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);
        return TestResultUtil.build(dto, calculateVos, variableNameMap);
    }

    private Map<String, BigDecimal> getVariableValue(CalculateDto calculateDto, List<FormulaInfoDto> formulaInfoList) {
        HashMap<String, BigDecimal> variableValueMap = new HashMap<String, BigDecimal>();
        Set<String> variableNamesSet = this.variableUtil.getAllVariableNameSet(formulaInfoList);
        log.info("\u81ea\u5b9a\u4e49\u53d8\u91cf,variableNamesSet:{}", (Object)JSONObject.toJSONString(variableNamesSet));
        log.info("\u8ba1\u7b97\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)calculateDto));
        Validate.notEmpty(variableNamesSet, (String)"\u81ea\u5b9a\u4e49\u53d8\u91cf%s\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{formulaInfoList});
        variableNamesSet.forEach(variableName -> {
            List list = this.formulaVariableRegisterList.stream().filter(register -> variableName.equals(register.getVariableCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                List<SourceCustomVariableEntity> customVariableList = this.sourceCustomVariableRepository.findByVariableCodes(Lists.newArrayList((Object[])new String[]{variableName}));
                Validate.notEmpty(customVariableList, (String)"\u81ea\u5b9a\u4e49\u53d8\u91cf[%s]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{variableName});
                FormulaCustomVariableRegister formulaCustomVariableRegister = this.variableUtil.getCustomRegister(customVariableList);
                Validate.notNull((Object)formulaCustomVariableRegister, (String)"\u62a5\u9519\u4fe1\u606f\u81ea\u5b9a\u4e49\u53d8\u91cf[%s]\u6240\u5c5e\u516c\u7528\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[]{variableName});
                SourceCustomVariableDto sourceCustomVariableDto = (SourceCustomVariableDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)customVariableList.get(0), SourceCustomVariableDto.class, HashSet.class, ArrayList.class, new String[0]);
                variableValueMap.putAll(formulaCustomVariableRegister.calculateVariable(calculateDto, sourceCustomVariableDto));
            } else {
                FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)list.get(0);
                variableValueMap.putAll(formulaVariableRegister.calculateVariable(calculateDto));
            }
        });
        return variableValueMap;
    }

    public ControlsVo overallControl(ControlsDto controlsDto) {
        this.verifyParams(controlsDto);
        ControlsVo controlsVo = new ControlsVo();
        return controlsVo;
    }

    public void testFormula(List<FormulaInfoDto> formulaInfoList) {
        if (CollectionUtils.isEmpty(formulaInfoList)) {
            log.info("\u6d4b\u8bd5\u516c\u5f0f\u914d\u7f6e\u662f\u5426\u5408\u6cd5======>\u5f85\u9a8c\u8bc1\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        log.info("\u6d4b\u8bd5\u516c\u5f0f\u914d\u7f6e\u662f\u5426\u5408\u6cd5======>{}", (Object)JSONObject.toJSONString(formulaInfoList));
        HashMap variableValueMap = new HashMap();
        Set<String> variableNamesSet = this.variableUtil.getAllVariableNameSet(formulaInfoList);
        List<SourceCustomVariableEntity> customVariableEntityList = this.sourceCustomVariableRepository.findByVariableCodes(Lists.newArrayList(variableNamesSet));
        Map<String, SourceCustomVariableEntity> customVariableEntityMap = customVariableEntityList.stream().collect(Collectors.toMap(SourceCustomVariableEntity::getVariableCode, v -> v, (v1, v2) -> v2));
        variableNamesSet.forEach(variableName -> {
            List list = this.formulaVariableRegisterList.stream().filter(register -> variableName.equals(register.getVariableCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                Validate.isTrue((boolean)customVariableEntityMap.containsKey(variableName), (String)"\u6838\u9500\u57fa\u51c6\u6570\u636e\u6ca1\u6709\u7b26\u53f7\u8fde\u63a5", (Object[])new Object[]{variableName});
                variableValueMap.put(((SourceCustomVariableEntity)((Object)((Object)customVariableEntityMap.get(variableName)))).getVariableCode(), BigDecimal.ONE);
                return;
            }
            Validate.notEmpty(list, (String)"[%s]\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[]{variableName});
            FormulaVariableRegister formulaVariableRegister = (FormulaVariableRegister)list.get(0);
            variableValueMap.put(formulaVariableRegister.getVariableCode(), BigDecimal.ONE);
        });
        formulaInfoList.forEach(e -> {
            this.variableUtil.computeFormulaCondition(variableValueMap, (FormulaInfoDto)e, true);
            this.variableUtil.computeFormulaExpression(variableValueMap, (FormulaInfoDto)e, true);
        });
    }

    private void verifyParams(ControlsDto controlsDto) {
        Assert.hasText((String)controlsDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)controlsDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

