/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.service.impl;

import com.biz.crm.tpm.business.variable.local.utils.VariableUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableUsingRedisRegister;
import com.biz.crm.tpm.business.variable.sdk.service.VariableUsingRedisService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableUsingRedisServiceImpl
implements VariableUsingRedisService {
    private static final Logger log = LoggerFactory.getLogger(VariableUsingRedisServiceImpl.class);
    @Autowired(required=false)
    private List<FormulaVariableUsingRedisRegister> formulaVariableUsingRedisRegisterList;
    @Autowired(required=false)
    private VariableUtil variableUtil;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<CalculateVo> allCalculateConditionAndExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList, variableNameToVariableRegister);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateConditionAndExpression(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    public List<CalculateVo> allCalculateCondition(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList, variableNameToVariableRegister);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateCondition(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    public List<CalculateVo> allCalculateExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList, variableNameToVariableRegister);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateExpression(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    public List<CalculateVo> orCalculateConditionAndExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList;
            Map<String, BigDecimal> variableValueMap;
            CalculateVo calculateVo = this.variableUtil.orCalculateConditionAndExpression(calculateDto, variableValueMap = this.getVariableValue(calculateDto, formulaInfoList = calculateDto.getFormulaInfoDtoList(), variableNameToVariableRegister), formulaInfoList);
            if (Objects.isNull(calculateVo)) {
                calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionValue(Boolean.FALSE);
            }
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public List<CalculateVo> orCalculateCondition(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList;
            Map<String, BigDecimal> variableValueMap;
            CalculateVo calculateVo = this.variableUtil.orCalculateCondition(calculateDto, variableValueMap = this.getVariableValue(calculateDto, formulaInfoList = calculateDto.getFormulaInfoDtoList(), variableNameToVariableRegister), formulaInfoList);
            if (Objects.isNull(calculateVo)) {
                calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionValue(Boolean.FALSE);
            }
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public List<CalculateVo> orCalculateExpression(List<CalculateDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : calculateDtoList) {
            List formulaInfoList;
            Map<String, BigDecimal> variableValueMap;
            CalculateVo calculateVo = this.variableUtil.orCalculateExpression(calculateDto, variableValueMap = this.getVariableValue(calculateDto, formulaInfoList = calculateDto.getFormulaInfoDtoList(), variableNameToVariableRegister), formulaInfoList);
            if (Objects.isNull(calculateVo)) {
                calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionValue(Boolean.FALSE);
            }
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    private Map<String, List<CalculateDto>> groupCalculateDtoByVariableName(List<CalculateDto> calculateDtoList) {
        ConcurrentMap variableNameToCalculateDtoListMap = Maps.newConcurrentMap();
        calculateDtoList.forEach(calculateDto -> {
            List formulaInfoDtoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Set<String> variableNamesSet = this.variableUtil.getAllVariableNameSet(formulaInfoDtoList);
            variableNamesSet.forEach(variableName -> {
                if (variableNameToCalculateDtoListMap.containsKey(variableName)) {
                    List variableNameToCalculateDtoList = (List)variableNameToCalculateDtoListMap.get(variableName);
                    variableNameToCalculateDtoList.add(calculateDto);
                } else {
                    ArrayList variableNameToCalculateDtoList = Lists.newArrayList();
                    variableNameToCalculateDtoList.add(calculateDto);
                    variableNameToCalculateDtoListMap.put(variableName, variableNameToCalculateDtoList);
                }
            });
        });
        return variableNameToCalculateDtoListMap;
    }

    private Map<String, FormulaVariableUsingRedisRegister> upLoadVariableValuesToRedis(Map<String, List<CalculateDto>> variableNameToCalculateDtoListMap) {
        HashMap<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister = new HashMap<String, FormulaVariableUsingRedisRegister>(variableNameToCalculateDtoListMap.size() * 2);
        variableNameToCalculateDtoListMap.forEach((key, calculateDtoList) -> {
            List list = this.formulaVariableUsingRedisRegisterList.stream().filter(register -> key.equals(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            FormulaVariableUsingRedisRegister formulaVariableRegister = (FormulaVariableUsingRedisRegister)list.get(0);
            formulaVariableRegister.upLoadValuesToRedis(calculateDtoList);
            variableNameToVariableRegister.put((String)key, formulaVariableRegister);
        });
        return variableNameToVariableRegister;
    }

    private Map<String, BigDecimal> getVariableValue(CalculateDto calculateDto, List<FormulaInfoDto> formulaInfoList, Map<String, FormulaVariableUsingRedisRegister> variableNameToVariableRegister) {
        Set<String> variableNamesSet = this.variableUtil.getAllVariableNameSet(formulaInfoList);
        HashMap<String, BigDecimal> variableValueMap = new HashMap<String, BigDecimal>(variableNamesSet.size() * 2);
        variableNamesSet.forEach(variableName -> {
            FormulaVariableUsingRedisRegister formulaVariableUsingRedisRegister = (FormulaVariableUsingRedisRegister)variableNameToVariableRegister.get(variableName);
            Validate.notNull((Object)formulaVariableUsingRedisRegister, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            variableValueMap.putAll(formulaVariableUsingRedisRegister.calculateVariableUsingRedis(calculateDto));
        });
        return variableValueMap;
    }
}

