/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.service.impl;

import com.biz.crm.tpm.business.variable.local.utils.VariableUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateWarningDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaWarningVariableUsingRedisRegister;
import com.biz.crm.tpm.business.variable.sdk.service.WarningVariableUsingRedisService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarningVariableUsingRedisServiceImpl
implements WarningVariableUsingRedisService {
    private static final Logger log = LoggerFactory.getLogger(WarningVariableUsingRedisServiceImpl.class);
    @Autowired(required=false)
    private List<FormulaWarningVariableUsingRedisRegister> formulaWarningVariableUsingRedisRegisterList;
    @Autowired(required=false)
    private VariableUtil variableUtil;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<CalculateVo> allCalculateForWarning(List<CalculateWarningDto> calculateDtoList) {
        Validate.notNull(calculateDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<CalculateWarningDto>> variableNameToCalculateDtoListMap = this.groupCalculateDtoByVariableName(calculateDtoList);
        Map<String, FormulaWarningVariableUsingRedisRegister> variableNameToVariableRegisterMap = this.getVariableNameToVariableRegister(variableNameToCalculateDtoListMap);
        Set<CalculateWarningDto> completeCalculateWarningDtoList = this.upLoadVariableValuesToRedis(variableNameToCalculateDtoListMap, variableNameToVariableRegisterMap);
        Collection completeCalculateDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(completeCalculateWarningDtoList, CalculateWarningDto.class, CalculateDto.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList<CalculateVo> calculateVoList = new ArrayList<CalculateVo>();
        for (CalculateDto calculateDto : completeCalculateDtoList) {
            List formulaInfoList = calculateDto.getFormulaInfoDtoList();
            Map<String, BigDecimal> variableValueMap = this.getVariableValue(calculateDto, formulaInfoList, variableNameToVariableRegisterMap);
            List<CalculateVo> calculateResultList = this.variableUtil.allCalculateCondition(calculateDto, variableValueMap, formulaInfoList);
            Validate.noNullElements(calculateResultList, (String)"\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25", (Object[])new Object[0]);
            String code = calculateDto.getCode();
            calculateResultList.forEach(calculateResult -> calculateResult.setCode(code));
            calculateVoList.addAll(calculateResultList);
        }
        return calculateVoList;
    }

    private Map<String, List<CalculateWarningDto>> groupCalculateDtoByVariableName(List<CalculateWarningDto> calculateDtoList) {
        ConcurrentMap variableNameToCalculateDtoListMap = Maps.newConcurrentMap();
        calculateDtoList.forEach(calculateDto -> {
            List formulaInfoDtoList = calculateDto.getFormulaInfoDtoList();
            Validate.notNull((Object)formulaInfoDtoList, (String)"\u8ba1\u7b97\u516c\u5f0f\u65f6\uff0c\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Set<String> variableNamesSet = this.variableUtil.getAllVariableNameSet(formulaInfoDtoList);
            variableNamesSet.forEach(variableName -> {
                if (variableNameToCalculateDtoListMap.containsKey(variableName)) {
                    List variableNameToCalculateDtoList = (List)variableNameToCalculateDtoListMap.get(variableName);
                    variableNameToCalculateDtoList.add(calculateDto);
                } else {
                    ArrayList variableNameToCalculateDtoList = Lists.newArrayList();
                    variableNameToCalculateDtoList.add(calculateDto);
                    variableNameToCalculateDtoListMap.put(variableName, variableNameToCalculateDtoList);
                }
            });
        });
        return variableNameToCalculateDtoListMap;
    }

    private Map<String, FormulaWarningVariableUsingRedisRegister> getVariableNameToVariableRegister(Map<String, List<CalculateWarningDto>> variableNameToCalculateDtoListMap) {
        HashMap<String, FormulaWarningVariableUsingRedisRegister> variableNameToVariableRegister = new HashMap<String, FormulaWarningVariableUsingRedisRegister>(variableNameToCalculateDtoListMap.size() * 2);
        variableNameToCalculateDtoListMap.forEach((key, calculateDtoList) -> {
            List list = this.formulaWarningVariableUsingRedisRegisterList.stream().filter(register -> key.equals(register.getVariableCode())).collect(Collectors.toList());
            Validate.noNullElements(list, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            FormulaWarningVariableUsingRedisRegister formulaWarningVariableUsingRedisRegister = (FormulaWarningVariableUsingRedisRegister)list.get(0);
            variableNameToVariableRegister.put((String)key, formulaWarningVariableUsingRedisRegister);
        });
        return variableNameToVariableRegister;
    }

    private Set<CalculateWarningDto> upLoadVariableValuesToRedis(Map<String, List<CalculateWarningDto>> variableNameToCalculateDtoListMap, Map<String, FormulaWarningVariableUsingRedisRegister> variableNameToVariableRegisterMap) {
        Set calculateWarningDtoSet = Sets.newConcurrentHashSet();
        variableNameToCalculateDtoListMap.forEach((key, calculateDtoList) -> {
            FormulaWarningVariableUsingRedisRegister formulaWarningVariableUsingRedisRegister = (FormulaWarningVariableUsingRedisRegister)variableNameToVariableRegisterMap.get(key);
            Validate.notNull((Object)formulaWarningVariableUsingRedisRegister, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            List calculateWarningDtoList = formulaWarningVariableUsingRedisRegister.upLoadWarningValuesToRedis(calculateDtoList);
            calculateWarningDtoSet.addAll(calculateWarningDtoList);
        });
        return calculateWarningDtoSet;
    }

    private Map<String, BigDecimal> getVariableValue(CalculateDto calculateDto, List<FormulaInfoDto> formulaInfoList, Map<String, FormulaWarningVariableUsingRedisRegister> variableNameToVariableRegister) {
        Set<String> variableNamesSet = this.variableUtil.getAllVariableNameSet(formulaInfoList);
        HashMap<String, BigDecimal> variableValueMap = new HashMap<String, BigDecimal>(variableNamesSet.size() * 2);
        variableNamesSet.forEach(variableName -> {
            FormulaWarningVariableUsingRedisRegister formulaVariableUsingRedisRegister = (FormulaWarningVariableUsingRedisRegister)variableNameToVariableRegister.get(variableName);
            Validate.notNull((Object)formulaVariableUsingRedisRegister, (String)"\u53d8\u91cf\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            variableValueMap.putAll(formulaVariableUsingRedisRegister.calculateVariableUsingRedis(calculateDto));
        });
        return variableValueMap;
    }
}

