/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormsOperationStrategy;
import com.biz.crm.tpm.business.variable.local.entity.SaleVolumeCriterion;
import com.biz.crm.tpm.business.variable.local.model.SaleVolumeCriterionVo;
import com.biz.crm.tpm.business.variable.local.register.configurable.RebateCriterionModuleRegister;
import com.biz.crm.tpm.business.variable.local.repository.SaleVolumeCriterionRepository;
import com.biz.crm.tpm.business.variable.sdk.vo.dynamic.AbstractCriterionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaleVolumeCriterionVoOperationStrategy
implements DynamicFormsOperationStrategy<SaleVolumeCriterionVo> {
    @Autowired(required=false)
    private SaleVolumeCriterionRepository saleVolumeCriterionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String dynamicFormCode() {
        return "CPXSSL";
    }

    public String dynamicFormName() {
        return "\u8fd4\u5229\u53d8\u91cf\u4e2d\u53ef\u914d\u7f6e\u7684\u9500\u552e\u6570\u91cf";
    }

    public Class<SaleVolumeCriterionVo> dynamicFormClass() {
        return SaleVolumeCriterionVo.class;
    }

    public String moduleCode() {
        return RebateCriterionModuleRegister.class.getName();
    }

    public int getOrder() {
        return 0;
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
        this.saleVolumeCriterionRepository.deleteBySaleRebatePolicyCode(parentCode);
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey, String[] detailCodes) {
        this.saleVolumeCriterionRepository.deleteBySaleRebatePolicyCodeAndInstanceCodeIn(parentCode, detailCodes);
    }

    public void onDynamicFormsCreate(Collection<SaleVolumeCriterionVo> dynamicForms, String dynamicKey, String parentCode, Object parent) {
        ArrayList list = Lists.newArrayListWithCapacity((int)dynamicForms.size());
        for (SaleVolumeCriterionVo dynamicForm : dynamicForms) {
            SaleVolumeCriterion saleVolumeCriterion = this.copyObject(parentCode, dynamicForm);
            list.add(saleVolumeCriterion);
        }
        this.saleVolumeCriterionRepository.saveBatch(list);
    }

    public void onDynamicFormsModify(Collection<SaleVolumeCriterionVo> dynamicForms, String dynamicKey, String parentCode, Object parent) {
        List<String> instanceCodes = dynamicForms.stream().map(AbstractCriterionVo::getInstanceCode).collect(Collectors.toList());
        List<SaleVolumeCriterion> idAndInstanceList = this.saleVolumeCriterionRepository.findIdAndInstanceByPolicyAndInstanceIn(parentCode, instanceCodes);
        HashMap<String, String> instanceToIdMap = new HashMap<String, String>(idAndInstanceList.size() * 2);
        for (SaleVolumeCriterion criterion : idAndInstanceList) {
            instanceToIdMap.put(criterion.getInstanceCode(), criterion.getId());
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)dynamicForms.size());
        for (SaleVolumeCriterionVo dynamicForm : dynamicForms) {
            SaleVolumeCriterion saleVolumeCriterion = this.copyObject(parentCode, dynamicForm);
            saleVolumeCriterion.setId((String)instanceToIdMap.get(dynamicForm.getInstanceCode()));
            list.add(saleVolumeCriterion);
        }
        this.saleVolumeCriterionRepository.saveOrUpdateBatch(list);
    }

    private SaleVolumeCriterion copyObject(String parentCode, SaleVolumeCriterionVo dynamicForm) {
        SaleVolumeCriterion saleVolumeCriterion = (SaleVolumeCriterion)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dynamicForm, SaleVolumeCriterion.class, HashSet.class, ArrayList.class, new String[]{"productCodes", "productLevels"}));
        saleVolumeCriterion.setSaleRebatePolicyCode(parentCode);
        List<String> productCodes = dynamicForm.getProductCodes();
        String productCodeStr = StringUtils.join(productCodes, (String)",");
        saleVolumeCriterion.setProductCodes(productCodeStr);
        List<String> productLevels = dynamicForm.getProductLevels();
        String productLevelStr = StringUtils.join(productLevels, (String)",");
        saleVolumeCriterion.setProductLevels(productLevelStr);
        if (Objects.nonNull(saleVolumeCriterion.getRightTime())) {
            // empty if block
        }
        return saleVolumeCriterion;
    }

    public Collection<SaleVolumeCriterionVo> findByParentCode(String dynamicKey, String parentCode) {
        List<SaleVolumeCriterion> saleVolumeCriterionList = this.saleVolumeCriterionRepository.findBySaleRebatePolicyCode(parentCode);
        ArrayList list = Lists.newArrayListWithCapacity((int)saleVolumeCriterionList.size());
        for (SaleVolumeCriterion saleVolumeCriterion : saleVolumeCriterionList) {
            String productLevels;
            SaleVolumeCriterionVo saleVolumeCriterionVo = (SaleVolumeCriterionVo)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)saleVolumeCriterion, SaleVolumeCriterionVo.class, HashSet.class, ArrayList.class, new String[]{"productCodes", "productLevels"}));
            saleVolumeCriterionVo.setParentCode(parentCode);
            saleVolumeCriterionVo.setDynamicKey(dynamicKey);
            String productCodes = saleVolumeCriterion.getProductCodes();
            if (StringUtils.isNotBlank((CharSequence)productCodes)) {
                Object[] split = productCodes.split(",");
                ArrayList strings = Lists.newArrayList((Object[])split);
                saleVolumeCriterionVo.setProductCodes(strings);
            }
            if (StringUtils.isNotBlank((CharSequence)(productLevels = saleVolumeCriterion.getProductLevels()))) {
                Object[] split = productLevels.split(",");
                ArrayList strings = Lists.newArrayList((Object[])split);
                saleVolumeCriterionVo.setProductLevels(strings);
            }
            list.add(saleVolumeCriterionVo);
        }
        return list;
    }
}

