/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.utils;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.repository.SourceCustomVariableRepository;
import com.biz.crm.tpm.business.variable.sdk.dto.SourceCustomVariableDto;
import com.biz.crm.tpm.business.variable.sdk.enums.CustomVariableSourceEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SourceCustomVariableUtil {
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private SourceCustomVariableRepository sourceCustomVariableRepository;
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisters;

    public void valCreate(SourceCustomVariableDto dto) {
        Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getVariableCode(), (String)"\u8bf7\u9009\u62e9\u53d8\u91cf\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getParamsJson(), (String)"\u8bf7\u9009\u62e9\u53c2\u6570\uff01", (Object[])new Object[0]);
        Map map = this.dictToolkitService.findMapByDictTypeCode("tpm_implementation_indicators");
        Validate.notNull((Object)map, (String)"\u672a\u68c0\u6d4b\u5230\u6570\u636e\u5b57\u5178[tpm_implementation_indicators]\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)map.containsKey(dto.getVariableCode()), (String)"\u53d8\u91cf\u672a\u5728\u6570\u636e\u5b57\u5178[tpm_implementation_indicators]\u4e2d\u914d\u7f6e\uff01", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getVariableName())) {
            dto.setVariableName((String)map.get(dto.getVariableCode()));
        }
    }

    public void valUpdate(SourceCustomVariableDto dto) {
        Validate.notEmpty((CharSequence)dto.getId(), (String)"ID\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.valCreate(dto);
    }

    public void checkDuplicate(SourceCustomVariableEntity entity) {
        Integer count = this.sourceCustomVariableRepository.findDuplicateCount(entity);
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u53d8\u91cf\uff01", (Object[])new Object[0]);
        for (FormulaVariableRegister variableRegister : this.formulaVariableRegisters) {
            Validate.isTrue((!entity.getVariableCode().equals(variableRegister.getVariableCode()) ? 1 : 0) != 0, (String)"\u53d8\u91cf\u7f16\u7801[%s]\u5df2\u88ab\u56fa\u5b9a\u53d8\u91cf[%s]\u4f7f\u7528\uff01", (Object[])new Object[]{entity.getVariableCode(), variableRegister.getVariableName()});
            Validate.isTrue((!entity.getVariableName().equals(variableRegister.getVariableName()) ? 1 : 0) != 0, (String)"\u53d8\u91cf\u540d\u79f0[%s]\u5df2\u88ab\u56fa\u5b9a\u53d8\u91cf[%s]\u4f7f\u7528\uff01", (Object[])new Object[]{entity.getVariableCode(), variableRegister.getVariableName()});
        }
    }

    public void packageEntity(SourceCustomVariableEntity entity) {
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDataSource(CustomVariableSourceEnum.EXECUTOR_INDICATOR.getCode());
    }
}

