/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.utils;

import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableCalTestVo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class TestResultUtil {
    public static VariableCalTestVo build(CalculateDto dto, List<CalculateVo> calculateVos, Map<String, String> variableNameMap) {
        VariableCalTestVo result = new VariableCalTestVo();
        List filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        Validate.isTrue((filterVos.size() < 2 ? 1 : 0) != 0, (String)"\u6838\u9500\u516c\u5f0f\u8ba1\u7b97\u7ed3\u679c\uff1a\u591a\u4e2a\u6838\u9500\u516c\u5f0f\u6761\u4ef6\u540c\u65f6\u6ee1\u8db3\uff01", (Object[])new Object[0]);
        BigDecimal estimatedWriteOffAmount = null;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = ((CalculateVo)filterVos.get(0)).getFormulaValue();
        }
        HashMap variableValueMap = new HashMap();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });
        HashMap conditionValueMap = new HashMap();
        HashMap formulaValueMap = new HashMap();
        dto.getFormulaInfoDtoList().forEach(formula -> {
            Set formulaCondition = MathUtil.getFormulaReplace((String)formula.getFormulaCondition());
            formulaCondition.forEach(v -> {
                if (conditionValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    conditionValueMap.put(v, variableNameMap.getOrDefault(v, (String)v) + " : " + ((BigDecimal)variableValueMap.get(v)).toString());
                    return;
                }
                conditionValueMap.put(v, variableNameMap.getOrDefault(v, (String)v) + " : ");
            });
            Set auditFormula = MathUtil.getFormulaReplace((String)formula.getFormula());
            auditFormula.forEach(v -> {
                if (formulaValueMap.containsKey(v)) {
                    return;
                }
                if (variableValueMap.containsKey(v)) {
                    formulaValueMap.put(v, variableNameMap.getOrDefault(v, (String)v) + " : " + ((BigDecimal)variableValueMap.get(v)).toString());
                    return;
                }
                formulaValueMap.put(v, variableNameMap.getOrDefault(v, (String)v) + " : ");
            });
        });
        result.setCondition(dto.getFormulaInfoDtoList().stream().map(FormulaInfoDto::getFormulaConditionName).filter(Objects::nonNull).collect(Collectors.joining(" , ")));
        result.setFormula(dto.getFormulaInfoDtoList().stream().map(FormulaInfoDto::getFormulaName).filter(Objects::nonNull).collect(Collectors.joining(" , ")));
        result.setConditionValue(String.join((CharSequence)" , ", conditionValueMap.values()));
        result.setFormulaValue(String.join((CharSequence)" , ", formulaValueMap.values()));
        result.setValue(estimatedWriteOffAmount);
        return result;
    }
}

