/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.variable.local.utils;

import com.alibaba.excel.util.StringUtils;
import com.biz.crm.tpm.business.variable.local.entity.SourceCustomVariableEntity;
import com.biz.crm.tpm.business.variable.local.utils.MathUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaCustomVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableConditionResultVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableResultVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class VariableUtil {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<FormulaCustomVariableRegister> formulaCustomVariableRegisters;

    public CalculateVo orCalculateConditionAndExpression(CalculateDto calculateDto, Map<String, BigDecimal> variableValueMap, List<FormulaInfoDto> formulaInfoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(formulaInfoList) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (FormulaInfoDto formulaInfo : formulaInfoList) {
            VariableConditionResultVo variableConditionResultVo = this.computeFormulaCondition(variableValueMap, formulaInfo, false);
            if (!variableConditionResultVo.getValue().booleanValue()) continue;
            VariableResultVo variableResultVo = this.computeFormulaExpression(variableValueMap, formulaInfo, false);
            CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
            calculateVo.setFormulaConditionName(variableConditionResultVo.getFormulaConditionName());
            calculateVo.setFormulaConditionValue(variableConditionResultVo.getValue());
            calculateVo.setFormulaValue(variableResultVo.getValue());
            calculateVo.setFormulaName(variableResultVo.getFormulaName());
            calculateVo.setVariableValueMap(variableValueMap);
            return calculateVo;
        }
        return null;
    }

    public List<CalculateVo> allCalculateConditionAndExpression(CalculateDto calculateDto, Map<String, BigDecimal> variableValueMap, List<FormulaInfoDto> formulaInfoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(formulaInfoList) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList calculateVoList = Lists.newArrayList();
        for (FormulaInfoDto formulaInfo : formulaInfoList) {
            VariableConditionResultVo variableConditionResultVo = this.computeFormulaCondition(variableValueMap, formulaInfo, false);
            if (variableConditionResultVo.getValue().booleanValue()) {
                VariableResultVo variableResultVo = this.computeFormulaExpression(variableValueMap, formulaInfo, false);
                CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
                calculateVo.setFormulaConditionName(variableConditionResultVo.getFormulaConditionName());
                calculateVo.setFormulaConditionValue(variableConditionResultVo.getValue());
                calculateVo.setFormulaValue(variableResultVo.getValue());
                calculateVo.setFormulaName(variableResultVo.getFormulaName());
                calculateVo.setVariableValueMap(variableValueMap);
                calculateVoList.add(calculateVo);
                continue;
            }
            CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
            calculateVo.setFormulaConditionName(variableConditionResultVo.getFormulaConditionName());
            calculateVo.setFormulaConditionValue(variableConditionResultVo.getValue());
            calculateVo.setVariableValueMap(variableValueMap);
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public CalculateVo orCalculateCondition(CalculateDto calculateDto, Map<String, BigDecimal> variableValueMap, List<FormulaInfoDto> formulaInfoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(formulaInfoList) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Iterator<FormulaInfoDto> iterator = formulaInfoList.iterator();
        if (iterator.hasNext()) {
            FormulaInfoDto formulaInfo = iterator.next();
            VariableConditionResultVo variableConditionResultVo = this.computeFormulaCondition(variableValueMap, formulaInfo, false);
            CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
            calculateVo.setFormulaConditionName(variableConditionResultVo.getFormulaConditionName());
            calculateVo.setFormulaConditionValue(variableConditionResultVo.getValue());
            calculateVo.setVariableValueMap(variableValueMap);
            return calculateVo;
        }
        return null;
    }

    public List<CalculateVo> allCalculateCondition(CalculateDto calculateDto, Map<String, BigDecimal> variableValueMap, List<FormulaInfoDto> formulaInfoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(formulaInfoList) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList calculateVoList = Lists.newArrayList();
        for (FormulaInfoDto formulaInfo : formulaInfoList) {
            VariableConditionResultVo variableConditionResultVo = this.computeFormulaCondition(variableValueMap, formulaInfo, false);
            CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
            calculateVo.setFormulaConditionName(variableConditionResultVo.getFormulaConditionName());
            calculateVo.setFormulaConditionValue(variableConditionResultVo.getValue());
            calculateVo.setVariableValueMap(variableValueMap);
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public CalculateVo orCalculateExpression(CalculateDto calculateDto, Map<String, BigDecimal> variableValueMap, List<FormulaInfoDto> formulaInfoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(formulaInfoList) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Iterator<FormulaInfoDto> iterator = formulaInfoList.iterator();
        if (iterator.hasNext()) {
            FormulaInfoDto formulaInfo = iterator.next();
            VariableResultVo variableResultVo = this.computeFormulaExpression(variableValueMap, formulaInfo, false);
            CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
            calculateVo.setFormulaValue(variableResultVo.getValue());
            calculateVo.setFormulaName(variableResultVo.getFormulaName());
            calculateVo.setVariableValueMap(variableValueMap);
            return calculateVo;
        }
        return null;
    }

    public List<CalculateVo> allCalculateExpression(CalculateDto calculateDto, Map<String, BigDecimal> variableValueMap, List<FormulaInfoDto> formulaInfoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(formulaInfoList) ? 1 : 0) != 0, (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList calculateVoList = Lists.newArrayList();
        for (FormulaInfoDto formulaInfo : formulaInfoList) {
            VariableResultVo variableResultVo = this.computeFormulaExpression(variableValueMap, formulaInfo, false);
            CalculateVo calculateVo = (CalculateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)calculateDto, CalculateVo.class, HashSet.class, ArrayList.class, new String[0]);
            calculateVo.setFormulaValue(variableResultVo.getValue());
            calculateVo.setFormulaName(variableResultVo.getFormulaName());
            calculateVo.setVariableValueMap(variableValueMap);
            calculateVoList.add(calculateVo);
        }
        return calculateVoList;
    }

    public VariableResultVo computeFormulaExpression(Map<String, BigDecimal> variableValueMap, FormulaInfoDto formulaInfo, boolean test) {
        Validate.notBlank((CharSequence)formulaInfo.getFormula(), (String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<String> variables = MathUtil.getFormulaReplace(formulaInfo.getFormula());
        String expressValue = formulaInfo.getFormula();
        expressValue = this.replaceExpression(expressValue, variables, variableValueMap);
        BigDecimal computeResult = MathUtil.computeFormula(expressValue, formulaInfo.getFormula(), test);
        Validate.notNull((Object)computeResult, (String)"\u516c\u5f0f\u3010%s\u3011\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u662f\u5426\u6b63\u786e", (Object[])new Object[]{formulaInfo.getFormula()});
        VariableResultVo variableResultVo = new VariableResultVo();
        variableResultVo.setValue(computeResult);
        variableResultVo.setFormulaName(formulaInfo.getFormulaName());
        return variableResultVo;
    }

    public VariableConditionResultVo computeFormulaCondition(Map<String, BigDecimal> variableValueMap, FormulaInfoDto formulaInfo, boolean test) {
        if (StringUtils.isBlank((CharSequence)formulaInfo.getFormulaCondition())) {
            VariableConditionResultVo variableConditionResultVo = new VariableConditionResultVo();
            variableConditionResultVo.setValue(Boolean.valueOf(true));
            variableConditionResultVo.setFormulaConditionName(formulaInfo.getFormulaConditionName());
            return variableConditionResultVo;
        }
        Set<String> variables = MathUtil.getFormulaReplace(formulaInfo.getFormulaCondition());
        String expressValue = formulaInfo.getFormulaCondition();
        Boolean computeResult = MathUtil.computeCondition(expressValue = this.replaceExpression(expressValue, variables, variableValueMap), formulaInfo.getFormulaCondition(), test);
        if (null == computeResult) {
            computeResult = false;
        }
        VariableConditionResultVo variableConditionResultVo = new VariableConditionResultVo();
        variableConditionResultVo.setValue(computeResult);
        variableConditionResultVo.setFormulaConditionName(formulaInfo.getFormulaConditionName());
        return variableConditionResultVo;
    }

    private String replaceExpression(String expression, Set<String> variables, Map<String, BigDecimal> variableValueMap) {
        for (String variable : variables) {
            BigDecimal value = variableValueMap.get(variable);
            Validate.notNull((Object)value, (String)"\u8ba1\u7b97\u65f6\u68c0\u6d4b\u5230\u53d8\u91cf\u3010%s\u3011\u503c\u4e3a\u7a7a", (Object[])new Object[]{variable});
            expression = expression.replace(variable, value.toString());
        }
        return expression;
    }

    public Set<String> getAllVariableNameSet(List<FormulaInfoDto> formulaInfoList) {
        HashSet<String> conditionAndFormula = new HashSet<String>();
        for (FormulaInfoDto formulaInfo : formulaInfoList) {
            if (!StringUtils.isBlank((CharSequence)formulaInfo.getFormulaCondition())) {
                Set<String> formulaConditions = MathUtil.getFormulaReplace(formulaInfo.getFormulaCondition());
                conditionAndFormula.addAll(formulaConditions);
            }
            Set<String> formulas = MathUtil.getFormulaReplace(formulaInfo.getFormula());
            conditionAndFormula.addAll(formulas);
        }
        return conditionAndFormula;
    }

    public FormulaCustomVariableRegister getCustomRegister(List<SourceCustomVariableEntity> customVariableList) {
        if (CollectionUtils.isEmpty(customVariableList)) {
            return null;
        }
        SourceCustomVariableEntity sourceCustomVariableEntity = customVariableList.get(0);
        List filterList = this.formulaCustomVariableRegisters.stream().filter(e -> e.getVariableCode().equals(sourceCustomVariableEntity.getDataSource())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterList)) {
            return null;
        }
        return (FormulaCustomVariableRegister)filterList.get(0);
    }
}

