package com.biz.crm.tpm.business.variable.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 计算dto
 *
 * @author ：dengwei
 * @date ：Created in 2022/11/3 14:07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "计算dto")
public class CalculateDto extends TenantFlagOpDto {

    /************************公共*************************/

    @ApiModelProperty(name = "唯一code")
    private String code;

    @ApiModelProperty(name = "唯一name")
    private String name;

    @ApiModelProperty(name = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "客户MDG编码")
    private String customerErpCode;

    @ApiModelProperty(name = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "产品编码集合")
    private List<String> excludeProductCodeList;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    private String activityFormCode;

    @ApiModelProperty(name = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date date;

    @ApiModelProperty(name = "开始时间/日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTimeOrDate;

    @ApiModelProperty(name = "结束时间/日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTimeOrDate;

    @ApiModelProperty(name = "公式", notes = "公式")
    private List<FormulaInfoDto> formulaInfoDtoList;

    /***************************核销***********************/

    @ApiModelProperty(name = "核销类型", notes = "核销类型")
    private String auditType;

    @ApiModelProperty(name = "活动年")
    private String yearLy;

    @ApiModelProperty(name = "年月", notes = "")
    private String yearMonthLy;

    @ApiModelProperty(name = "年月日")
    private String yearMonthDay;

    @ApiModelProperty(name = "销售机构编码")
    private String salesOrganizationCode;
    @ApiModelProperty(name = "销售机构短码")
    private String salesOrganizationErpCode;

    @ApiModelProperty(name = "销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty(name = "销售大区短码")
    private String salesRegionErpCode;

    @ApiModelProperty(name = "销售组编码")
    private String salesGroupCode;

    @ApiModelProperty(name = "销售组短码")
    private String salesGroupErpCode;

    @ApiModelProperty(name = "销售组织编码", notes = "")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售组织短码", notes = "")
    private String salesOrgErpCode;

    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    private String storesCode;

    @ApiModelProperty(name = "活动明细编码", notes = "活动明细编码")
    private String activitiesDetailCode;

    @ApiModelProperty(name = "活动细案明细编码")
    private String detailPlanItemCode;
    /************************合同*****************************/
    @ApiModelProperty(name = "区域编码")
    private String activityOrgCode;
    @ApiModelProperty(name = "区域名称")
    private String activityOrgName;
    @ApiModelProperty(name = "零售商code")
    private String retailBusinessmanCode;
    @ApiModelProperty(name = "零售商名称")
    private String retailBusinessmanName;

    @ApiModelProperty(name = "终端编码")
    private List<String> terminalCodes;

    /***************************预警***********************/

    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    private String subCode;

    @ApiModelProperty(name = "客户编码")
    private String customerName;

    @ApiModelProperty(name = "产品编码")
    private String productName;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "预警级别[数据字典:tpm_warning_level]", notes = "预警级别[数据字典:tpm_warning_level]")
    private String warningLevel;

    @ApiModelProperty(name = "客户编码集合")
    private Set<String> customerCodeList;

    /**********************************/
    @ApiModelProperty(name = "品类编码")
    private String categoryCode;

    @ApiModelProperty(name = "品项编码")
    private String itemCode;

    @ApiModelProperty(name = "品牌编码")
    private String brandCode;

    @ApiModelProperty(name = "sap市场编码")
    private String dealerCode;

    @ApiModelProperty(name = "方案明细编码")
    private String planItemCode;

    @ApiModelProperty(name = "电商客户等级编码")
    private String estoreCustomerLevel;

    @ApiModelProperty(name = "促销规划编码")
    private String promotionPlanCode;

    /*****************询价参数*******************/

    @ApiModelProperty(name = "终端编码")
    private String terminalCode;

    @ApiModelProperty(name = "价格类型编码")
    private String priceTypeCode;

    @ApiModelProperty(name = "价格绑定维度,商品维度")
    private String dimensionCode;

    @ApiModelProperty(name = "询价时间,不传默认服务端当前时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date searchTime;

    /**
     * 定价维度筛选项
     */
    @ApiModelProperty(name = "定价维度筛选项")
    private List<SearchPriceDimensionItemDto> dimensionItems;

    @ApiModelProperty(name = "定价区域编码")
    private String priceArea;

    @ApiModelProperty(name = "渠道编码")
    private String channel;

    @ApiModelProperty(name = "分销渠道编码")
    private String distributionChannel;

    @ApiModelProperty(name = "销售单位编码")
    private String saleUnit;

    @ApiModelProperty(name = "销售地区编码")
    private String saleRegion;

    @ApiModelProperty(name = "客户组编码")
    private String customerGroup;


    /**************分子活动细案******************/

//    @ApiModelProperty(name = "分子活动细案明细编码")
//    private String constituentDetailPlanItemCode;


    /**************主体活动细案******************/

    @ApiModelProperty(name = "人员编码", notes = "人员编码")
    private String personCode;

    @ApiModelProperty(name = "人员身份证号码", notes = "人员身份证号码")
    private String identityCard;

    @ApiModelProperty(name = "二级渠道", notes = "二级渠道")
    private String secondChannelCode;

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;


    /**************主体******************/
    @ApiModelProperty(name = "人员身份证", notes = "人员身份证")
    private String personIdCard;

    @ApiModelProperty(name = "一级渠道编码")
    private String firstChannelCode;

    @ApiModelProperty(name = "总部统筹预算项目编码")
    private String headBudgetItemCode;

    @ApiModelProperty(name = "大区预算项目编码")
    private String monthBudgetCode;

    @ApiModelProperty(name = "形式说明")
    private String specification;

    @ApiModelProperty(name = "是否临时活动")
    private String isTemporary;

    @ApiModelProperty(name = "客户创建时间")
    private Date cusCreateTime;

    @ApiModelProperty(name = "预提时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date withHoldDate;

    @ApiModelProperty(name = "预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(name = "部门编码")
    private String orgCode;

    /**************垂直******************/

    @ApiModelProperty(name = "产品编码集合，垂直变量专用，可能会修改值请勿作为传参")
    private Set<String> productCodeSetForVertical;

    @ApiModelProperty(name = "终端编码集合，垂直变量专用，可能会修改值请勿作为传参")
    private Set<String> terminalCodeSetForVertical;

    @ApiModelProperty(name = "库存盘点对象，大日期预提专用")
    private TpmInventoryCheckVo inventoryCheckVo;

    /**************商超费用********************/
    @ApiModelProperty(name = "细案预测管理，细案明细编码")
    private String activityDetailItemCode;

    @ApiModelProperty("送达方编码")
    private String deliveryPartyCode;

    @ApiModelProperty(name = "细案预测管理，细案明细编码list")
    private List<String> activityDetailItemCodeList;

    @ApiModelProperty(name = "产品编码集合（13码）")
    private List<String> productList;

    @ApiModelProperty(name = "门店编码集合（37码）")
    private List<String> storeList;

    @ApiModelProperty(name = "数据来源(垂直/分子)")
    private String dataSource;

    @ApiModelProperty("是否差异追踪")
    private Boolean isDiffTrack;
}
