package com.biz.crm.tpm.business.variable.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 计算预警dto 已重写equals方法，谨慎使用set、map等使用equals方法判断重复的集合！
 *
 * @author ：duyiran
 * @date ：Created in 2022/11/3 14:07
 * @description：计算dto
 */
@Data
@ApiModel(value = "计算dto")
public class CalculateWarningDto extends TenantFlagOpDto {

    /************************公共*************************/

    @ApiModelProperty("唯一code")
    private String code;

    @ApiModelProperty(name = "唯一name")
    private String name;

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    private String activityFormCode;

    @ApiModelProperty("日期")
    private Date date;

    @ApiModelProperty("开始时间/日期")
    private Date startTimeOrDate;

    @ApiModelProperty("结束时间/日期")
    private Date endTimeOrDate;

    @ApiModelProperty(name = "公式", notes = "公式")
    private List<FormulaInfoDto> formulaInfoDtoList;

    /***************************预警***********************/

    @ApiModelProperty("客户编码")
    private String customerName;

    @ApiModelProperty("产品编码")
    private String productName;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalculateWarningDto)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalculateWarningDto that = (CalculateWarningDto) o;
        String thisKey = "";
        String thatKey = "";
        if (StringUtils.isNotEmpty(code)) {
            thisKey += code;
        }
        if (StringUtils.isNotEmpty(customerCode)) {
            thisKey += customerCode;
        }
        if (StringUtils.isNotEmpty(productCode)) {
            thisKey += productCode;
        }
        if (CollectionUtils.isNotEmpty(formulaInfoDtoList)) {
            thisKey += formulaInfoDtoList;
        }
        if (StringUtils.isNotEmpty(that.code)) {
            thatKey += that.code;
        }
        if (StringUtils.isNotEmpty(that.customerCode)) {
            thatKey += that.customerCode;
        }
        if (StringUtils.isNotEmpty(that.productCode)) {
            thatKey += that.productCode;
        }
        if (CollectionUtils.isNotEmpty(that.formulaInfoDtoList)) {
            thatKey += that.formulaInfoDtoList;
        }
        return thisKey.equals(thatKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, customerCode, productCode, formulaInfoDtoList);
    }

}
