package com.biz.crm.tpm.business.variable.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 公式dto
 *
 * @author ：dengwei
 * @date ：Created in 2022/11/3 13:48
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "公式dto")
public class FormulaInfoDto extends TenantFlagOpDto {

    /************************公共*************************/

    @ApiModelProperty(name = "公式编码", notes = "公式编码")
    private String formulaCode;

    @ApiModelProperty("公式条件")
    private String formulaCondition;

    @ApiModelProperty("公式条件（展示用）")
    private String formulaConditionName;

    @ApiModelProperty("公式")
    private String formula;

    @ApiModelProperty("公式（展示用）")
    private String formulaName;

    /***************************预警***********************/

    @ApiModelProperty(name = "预警级别[数据字典:tpm_warning_level]", notes = "预警级别[数据字典:tpm_warning_level]")
    private String warningLevel;

}
