package com.biz.crm.tpm.business.variable.sdk.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 可配置变量明细类型[数据字典:tpm_con_item_type]
 *
 * @author YangWei
 * @Date 2023/3/17 上午10:32
 */
public enum ConItemTypeEnum {

    BRAND("brand", "品牌"),
    ITEM("item", "品项"),
    CATEGORY("category", "品类"),
    GOODS("goods", "产品非包含"),
    INCLUDE_GOODS("includeGoods", "产品包含"),
    CUSTOMER("customer", "客户"),
    INCLUDE_SALES_ORG("includeSalesOrg", "可选销售组织"),
    INCLUDE_ACTIVITY_FORM("includeActivityForm", "可选活动形式"),
    ;

    ConItemTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static ConItemTypeEnum findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (ConItemTypeEnum type : values()) {
            if (StringUtils.equals(type.getCode(), code)) {
                return type;
            }
        }
        return null;
    }

    public static List<String> findCodeByEnums(List<ConItemTypeEnum> enumList) {
        List<String> result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(enumList)) {
            return result;
        }
        for (ConItemTypeEnum function : enumList) {
            result.add(function.getCode());
        }
        return result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
