package com.biz.crm.tpm.business.variable.sdk.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 自定义变量数据源
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-24
 */
public enum CustomVariableSourceEnum {

    EXECUTOR_INDICATOR("executorIndicator", "执行指标表"),
    ;

    CustomVariableSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static CustomVariableSourceEnum findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (CustomVariableSourceEnum type : values()) {
            if (StringUtils.equals(type.getCode(), code)) {
                return type;
            }
        }
        return null;
    }

    public static List<String> findCodeByEnums(List<CustomVariableSourceEnum> enumList) {
        List<String> result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(enumList)) {
            return result;
        }
        for (CustomVariableSourceEnum function : enumList) {
            result.add(function.getCode());
        }
        return result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }


}
