package com.biz.crm.tpm.business.variable.sdk.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 可配置变量汇总维度[数据字典:tpm_custom_variable_summary_dimension]
 *
 * @author YangWei
 * @Date 2023/3/17 上午10:32
 */
public enum CustomVariableSummaryDimensionEnum {

    FIRST_CHANNEL_PRODUCT("first_channel_product","一级渠道+产品"),
    SECOND_CHANNEL_PRODUCT("second_channel_product","二级渠道+产品"),
    CUSTOMER_PRODUCT("customer_product","客户+产品"),
    ;

    CustomVariableSummaryDimensionEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static CustomVariableSummaryDimensionEnum findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(CustomVariableSummaryDimensionEnum type : values()){
            if(StringUtils.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public static List<String> findCodeByEnums(List<CustomVariableSummaryDimensionEnum> enumList){
        List<String> result = Lists.newArrayList();
        if(CollectionUtils.isEmpty(enumList)){
            return result;
        }
        for(CustomVariableSummaryDimensionEnum function : enumList){
            result.add(function.getCode());
        }
        return result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
