package com.biz.crm.tpm.business.variable.sdk.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Description:季度枚举
 * @Author qiancheng
 * @Date 2023/8/23
 */
public enum QuarterEnum {

    Q1("q1","一季度1-3月"),
    Q2("q2","二季度4-6月"),
    Q3("q3","三季度7-9月"),
    ;
    QuarterEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static QuarterEnum findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (QuarterEnum type : values()) {
            if (StringUtils.equals(type.getCode(), code)) {
                return type;
            }
        }
        return null;
    }

    public static List<String> findCodeByEnums(List<QuarterEnum> enumList) {
        List<String> result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(enumList)) {
            return result;
        }
        for (QuarterEnum function : enumList) {
            result.add(function.getCode());
        }
        return result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
