package com.biz.crm.tpm.business.variable.sdk.enums;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 预警配置状态[数据字典:tpm_warning_config_status]
 *
 * @author duyiran
 * @create 2022-11-03 20:00
 */
public enum VariableFunctionEnum {

    WITHHOLDING("withholding","预提"),
    AUDIT("audit","核销"),
    WARNING("warning","预警"),
    APPLY("apply","申请"),
    CONTRACT("contract","合同"),
    BUDGET("budget","预算"),
    LARGEDATE("largeDate","大日期"),
    AUDIT_FEE("audit_fee","商超费用"),
    ;

    VariableFunctionEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static VariableFunctionEnum findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(VariableFunctionEnum type : values()){
            if(StringUtils.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public static List<String> findCodeByEnums(List<VariableFunctionEnum> enumList){
        List<String> result = Lists.newArrayList();
        if(CollectionUtils.isEmpty(enumList)){
            return result;
        }
        for(VariableFunctionEnum function : enumList){
            result.add(function.getCode());
        }
        return result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
