package com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/14 19:56
 * @description: 结案核销执行指标主表Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditExecuteIndicatorDto", description = "结案核销执行指标主表Dto")
public class AuditExecuteIndicatorDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "指标编码", notes = "指标编码")
    private String indicatorCode;

    @ApiModelProperty(name = "指标名称", notes = "指标名称")
    private String indicatorName;

    @ApiModelProperty(name = "变量编码", notes = "变量编码")
    private String variableCode;

    @ApiModelProperty(name = "指标值", notes = "指标值")
    private BigDecimal indicatorValue;

    @ApiModelProperty(name = "对接系统", notes = "对接系统")
    private String dockingSystem;

    @ApiModelProperty(name = "年月", notes = "年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearAndMonth;
    private String yearAndMonthStr;
    private String yearStr;

    @ApiModelProperty(value = "salesInstitutionCode", name = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(value = "salesInstitutionName", name = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty(value = "salesInstitutionErpCode", name = "销售机构erp编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    private String salesRegionCode;

    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    private String salesRegionName;

    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    private String salesRegionErpCode;

    @ApiModelProperty(value = "salesOrgCode", name = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty(value = "salesOrgName", name = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    @ApiModelProperty(value = "salesOrgErpCode", name = "销售组织erp编码", notes = "销售组织erp编码")
    private String salesOrgErpCode;

    @ApiModelProperty(name = "渠道编码", notes = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "渠道名称", notes = "渠道名称")
    private String channelName;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;
    private List<String> customerCodes;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "客户erp编码", notes = "客户erp编码")
    private String customerErpCode;

    @ApiModelProperty(name = "门店编码", notes = "门店编码")
    private String storesCode;
    private List<String> storesCodes;

    @ApiModelProperty(name = "门店名称", notes = "门店名称")
    private String storesName;

    @ApiModelProperty(name = "人员类型", notes = "人员类型")
    private String personnelType;

    @ApiModelProperty(name = "人员Id", notes = "人员Id")
    private String personnelId;

    /**
     * 牛人管家活动执行结果信息字段
     */
    @ApiModelProperty(name = "费用类型")
    private String costType;

    @ApiModelProperty(name = "活动细案明细编码")
    private String activeNumber;

    @ApiModelProperty(name = "状态编码", notes = "0不合格,1合格 ")
    private String isQualifiedCode;

    @ApiModelProperty(name = "状态", notes = "合格/不合格")
    private String isQualified;

    @ApiModelProperty(name = "不合格原因")
    private String isQualifiedReason;

    @ApiModelProperty(name = "是否关闭活动编码", notes = "0否,1是")
    private String activityStatusCode;

    @ApiModelProperty(name = "是否关闭活动")
    private String activityStatus;

    @ApiModelProperty(name = "扣减活动金额")
    private String inspectCost;
    private BigDecimal inspectCosts;

    @ApiModelProperty(name = "扣减大区金额")
    private String regionInspectCost;
    private BigDecimal regionInspectCosts;

    /**
     * SAP促销活动执行结果字段
     */

    @ApiModelProperty(name = "活动发生数量")
    private BigDecimal expensesAmount;

    @ApiModelProperty(name = "活动发生费用")
    private BigDecimal expensesIncurred;

    @ApiModelProperty("人员编码")
    private String personCode;

    @ApiModelProperty("人员名称")
    private String personName;

    @ApiModelProperty("员工类型编码")
    private String employeeTypeCode;

    @ApiModelProperty("员工类型名称")
    private String employeeTypeName;

    @ApiModelProperty("所属大区编码")
    private String regionCode;

    @ApiModelProperty("所属大区名称")
    private String regionName;

    @ApiModelProperty(name = "customerRetailerCode", notes = "所属零售商编码")
    private String customerRetailerCode;

    @ApiModelProperty(name = "customerRetailerName", notes = "所属零售商名称")
    private String customerRetailerName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;
    private List<String> productCodeList;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;
    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "品牌编码")
    private String productBrandCode;
    private List<String> productBrandCodeList;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "品牌名称")
    private String productBrandName;
    /**
     * 所属品类编码
     */
    @ApiModelProperty("所属品类编码")
    private String productCategoryCode;
    private List<String> productCategoryCodeList;

    /**
     * 所属品类名称
     */
    @ApiModelProperty(name = "所属品类名称", notes = "所属品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    private List<String> productItemCodeList;
    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "品项名称")
    private String productItemName;


    @ApiModelProperty(name = "活动类型编码", notes = "活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    private String activityFormCode;

    @ApiModelProperty(name = "活动开始时间", notes = "活动开始时间")
    private String activityBeginDate;

    @ApiModelProperty(name = "活动结束时间", notes = "活动结束时间")
    private String activityEndDate;

    @ApiModelProperty(name = "人员身份证", notes = "人员身份证")
    private String personIdCard;

//    @ApiModelProperty(name = "细案明细编码", notes = "细案明细编码")
//    private String detailPlanItemCode;

    @ApiModelProperty("一级渠道编码")
    private String firstChannelCode;

    @ApiModelProperty("一级渠道名称")
    private String firstChannelName;

    @ApiModelProperty("二级渠道编码")
    private String secondChannelCode;

    @ApiModelProperty("二级渠道名称")
    private String secondChannelName;

    @ApiModelProperty("总部统筹预算项目编码")
    private String headBudgetItemCode;

    @ApiModelProperty("大区预算项目编码")
    private String monthBudgetCode;

    @ApiModelProperty("形式说明")
    private String specification;

    @ApiModelProperty("是否临时活动")
    private String isTemporary;

    @ApiModelProperty(name = "扣减数量")
    private String deductionQuantity;

    @ApiModelProperty("更新时间")
    private String upDataTime;

    @ApiModelProperty("牛人管家-扣减金额new")
    private String deductionExpenses;

    @ApiModelProperty("细案明细")
    private List<String> detailPlanItemCodes;

}
