package com.biz.crm.tpm.business.variable.sdk.executeIndicator.log;

import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author: chenlong
 * @date: 2022/11/15 9:48
 * @description: 结案核销-执行指标表日志监听
 */
public interface AuditExecuteIndicatorEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param eventDto 事件dto
     */
    void onCreate(AuditExecuteIndicatorLogEventDto eventDto);

    /**
     * 删除事件
     *
     * @param eventDto 事件dto
     */
    void onDelete(AuditExecuteIndicatorLogEventDto eventDto);

    /**
     * 更新日志
     *
     * @param eventDto 事件dto
     */
    void onUpdate(AuditExecuteIndicatorLogEventDto eventDto);

    /**
     * 启用
     *
     * @param eventDto 事件dto
     */
    void onEnable(AuditExecuteIndicatorLogEventDto eventDto);

    /**
     * 禁用
     *
     * @param eventDto 事件dto
     */
    void onDisable(AuditExecuteIndicatorLogEventDto eventDto);
}
