package com.biz.crm.tpm.business.variable.sdk.executeIndicator.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.dto.AuditExecuteIndicatorDto;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorSdkVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/11/14 19:24
 * @description: 结案核销-执行指标表(AuditExecuteIndicator)表服务接口
 */
public interface AuditExecuteIndicatorService {

    /**
     * 分页查询所有数据
     *
     * @param pageable                 分页对象
     * @param auditExecuteIndicatorDto 查询dto
     * @return 所有数据
     */
    Page<AuditExecuteIndicatorVo> findByConditions(Pageable pageable,
                                                   AuditExecuteIndicatorDto auditExecuteIndicatorDto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    AuditExecuteIndicatorVo findById(String id);

    /**
     * 修改数据
     *
     * @param dto dto对象
     * @return 修改结果
     */
    void update(AuditExecuteIndicatorDto dto);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    void delete(List<String> idList);

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 大批量保存
     *
     * @param importList 导入数据列表
     */
    void bulkImportSave(List<AuditExecuteIndicatorDto> importList);

    /**
     * 批量新增
     * @param saveList 新增数据集合
     * @param updateList 更新数据集合
     */
    void bulkSaveOrUpdate(List<AuditExecuteIndicatorDto> saveList,List<AuditExecuteIndicatorDto> updateList);

    /**
     * 条件查询
     * @param dto
     * @return
     */
    List<AuditExecuteIndicatorVo> findListByCondition(AuditExecuteIndicatorDto dto);


    /**
     * 从sap查询所有活动的执行结果
     */
    void queryAllExecutionSapBranch();

    /**
     * 更据销售机构、促销活动号，查询活动执行结果
     * @param orgCode 销售机构编码
     * @param itemCode （活动细案活动）明细编码，（分子公司活动细案活动）促销活动号
     * @param activityDate 日期
     */
    void queryExecutionSapBranch(String orgCode,String itemCode,String activityDate);

    /**
     * 根据活动细案明细编码+指标名称查询
     *
     * @param activeNumber
     * @return
     */
    List<AuditExecuteIndicatorVo> findByCode(String activeNumber,String indicatorName);
    List<AuditExecuteIndicatorVo> findByCodeList(List<String> activeNumberList,String indicatorName);

    /**
     * 时间+客户+销售组织维度查询数据
     *
     * @param dto
     * @return
     */
    List<AuditExecuteIndicatorVo> findData(AuditExecuteIndicatorDto dto);

    /**
     * 更据 明细编码+来源系统+业务单元 查询数据是否存在
     * @param activeNumbers 明细编码集合
     * @param dockingSystem 来源系统
     * @param businessUnitCode 业务单元
     * @return
     */
    List<AuditExecuteIndicatorVo> findByActiveNumber(List<String> activeNumbers,String dockingSystem,String businessUnitCode);

    /**
     * 通过唯一维度查询Id
     *
     * @param onlyKeys 唯一维度拼接编码列表
     * @return Map<String, String>
     */
    Map<String, String> findByOnlyKeys(List<String> onlyKeys);

    /**
     * 查询sap发生额通过活动细案编码
     *
     * @param itemNos 细案明细编码
     * @param nameType 名字映射数据字典编码
     * @return Map<String, BigDecimal>
     **/
    Map<String, BigDecimal> getSapAmountByDetailItemNos(List<String> itemNos, String nameType);

    /**
     * 查询sap发生额和发生两量通过活动细案编码
     *
     * @param itemNos 细案明细编码
     * @return List<AuditExecuteIndicatorVo>
     **/
    List<AuditExecuteIndicatorVo> getSapAmountAndQuantityByDetailItemNos(List<String> itemNos);

    /**
     * 指标取数
     * @param dto
     * @return
     */
    List<AuditExecuteIndicatorVo> findListForVariable(AuditExecuteIndicatorDto dto);

    /**
     * 人员工资
     *
     * @param dto 参数
     * @return List<AuditExecuteIndicatorVo>
     **/
    List<AuditExecuteIndicatorVo> getPersonnelWage(AuditExecuteIndicatorDto dto);

    /**
     * 查询sap发生量、sap发生额 根据细案明细编码
     *
     * @param detailPlanItemCodes
     * @return
     */
    List<AuditExecuteIndicatorSdkVo> findSapDataByActiveNumbers(List<String> detailPlanItemCodes,List<String> indicatorNames);

    List<AuditExecuteIndicatorVo> getMinusCompostQuantity(List<String> detailPlanItemCodes);

}
