package com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: hd
 * @description: 结案核销-执行指标表-核减金额导入vo
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class AuditExecuteIndicatorDeductionAmountImportVo extends CrmExcelVo {

    /**
     * 业态（数据字典：mdm_business_format）
     */
    @CrmExcelColumn(value = "*业态", order = 0)
    private String businessFormatCode;

    /**
     * 业务单元（数据字典：mdm_business_unit）
     */
    @CrmExcelColumn(value = "*业务单元", order = 1)
    private String businessUnitCode;

    /**
     * 年月（yyyy-MM）
     */
    @CrmExcelColumn(value = "*年月(例：2022-09)", order = 2)
    private String yearAndMonthStr;

    @CrmExcelColumn(value = "细案明细号", order = 3)
    private String activeNumber;

    @CrmExcelColumn(value = "*指标名称", order = 4)
    private String indicatorName;

    private BigDecimal indicatorValue;

    @CrmExcelColumn(value = "*指标值(数字)", order = 5)
    private String indicatorValueStr;


    @CrmExcelColumn(value = "*状态", order = 6)
    private String isQualified;

    @CrmExcelColumn(value = "*不合格原因", order = 7)
    private String isQualifiedReason;

    @CrmExcelColumn(value = "*渠道编码", order = 8)
    private String channelCode;

    @CrmExcelColumn(value = "客户编码", order = 9)
    private String customerCode;
    @CrmExcelColumn(value = "客户名称", order = 10)
    private String customerName;
    @CrmExcelColumn(value = "区域名称", order = 11)
    private String regionName;

    @CrmExcelColumn(value = "所属零售商名称", order = 12)
    private String customerRetailerName;

    @CrmExcelColumn(value = "*所属门店编码", order = 13)
    private String storesCode;

    @CrmExcelColumn(value = "*是否关闭活动", order = 14)
    private String activityStatus;

    @CrmExcelColumn(value = "*扣减大区金额", order = 15)
    private String regionInspectCostsStr;
    private BigDecimal regionInspectCosts;

    @CrmExcelColumn(value = "*扣减活动金额", order = 16)
    private String inspectCostsStr;
    private BigDecimal inspectCosts;


    @ExcelIgnore
    @ApiModelProperty(name = "状态编码", notes = "0不合格,1合格 ")
    private String isQualifiedCode;
    @ExcelIgnore
    private String indicatorCode;
    @ExcelIgnore
    private String channelName;

    @ExcelIgnore
    @ApiModelProperty("所属大区编码")
    private String regionCode;

    @ExcelIgnore
    @ApiModelProperty(name = "所属零售商编码")
    private String customerRetailerCode;

    @ExcelIgnore
    private String storesName;
    @ExcelIgnore
    private String activityStatusCode;

    @ExcelIgnore
    private String customerErpCode;

    @ExcelIgnore
    private String salesInstitutionCode;
    @ExcelIgnore
    @ApiModelProperty(value = "salesInstitutionName", name = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;
    @ExcelIgnore
    @ApiModelProperty(value = "salesInstitutionErpCode", name = "销售机构erp编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;
    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    private String salesRegionCode;
    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    private String salesRegionName;
    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    private String salesRegionErpCode;
    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgCode", name = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgName", name = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgErpCode", name = "销售组织erp编码", notes = "销售组织erp编码")
    private String salesOrgErpCode;
    @ExcelIgnore
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearAndMonth;
    @ExcelIgnore
    private String dockingSystem;
}
