package com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/11/15 15:30
 * @description: 结案核销-执行指标表导入vo
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class AuditExecuteIndicatorImportVo extends CrmExcelVo {

    /**
     * 业态（数据字典：mdm_business_format）
     */
    @CrmExcelColumn(value = "*业态", order = 0)
    private String businessFormatCode;

    /**
     * 业务单元（数据字典：mdm_business_unit）
     */
    @CrmExcelColumn(value = "*业务单元", order = 1)
    private String businessUnitCode;

    /**
     * 年月（yyyy-MM）
     */
    @CrmExcelColumn(value = "*年月(例：2022-09)", order = 2)
    private String yearAndMonthStr;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "*销售机构编码", order = 3)
    private String salesInstitutionCode;

    /**
     * 渠道编码
     */
    @CrmExcelColumn(value = "*渠道编码", order = 4)
    private String channelCode;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "*客户编码", order = 5)
    private String customerCode;

    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码", order = 6)
    private String storesCode;

    /**
     * 人员类型
     */
    @CrmExcelColumn(value = "人员类型", order = 7)
    private String personnelType;

    @CrmExcelColumn(value = "人员身份证", order = 8)
    private String personIdCard;

    /**
     * 人员Id
     */
    @CrmExcelColumn(value = "人员名称", order = 9)
    private String personName;

    @CrmExcelColumn(value = "活动分类编码", order = 10)
    private String activityTypeCode;

    @CrmExcelColumn(value = "活动分类名称", order = 11)
    private String activityTypeName;

    @CrmExcelColumn(value = "活动形式编码", order = 12)
    private String activityFormCode;

    @CrmExcelColumn(value = "活动形式名称", order = 13)
    private String activityFormName;

    @CrmExcelColumn(value = "活动开始时间", order = 14)
    private String activityBeginDate;

    @CrmExcelColumn(value = "活动结束时间", order = 15)
    private String activityEndDate;

    @CrmExcelColumn(value = "零售商编码", order = 16)
    private String customerRetailerCode;

    @CrmExcelColumn(value = "零售商名称", order = 17)
    private String customerRetailerName;

    @CrmExcelColumn(value = "细案明细编码", order = 18)
    private String activeNumber;

    @CrmExcelColumn(value = "一级渠道编码", order = 19)
    private String firstChannelCode;

    @CrmExcelColumn(value = "一级渠道名称", order = 20)
    private String firstChannelName;

    @CrmExcelColumn(value = "二级渠道编码", order = 21)
    private String secondChannelCode;

    @CrmExcelColumn(value = "二级渠道名称", order = 22)
    private String secondChannelName;

    @CrmExcelColumn(value = "品牌编码", order = 23)
    private String productBrandCode;

    @CrmExcelColumn(value = "品牌名称", order = 24)
    private String productBrandName;

    @CrmExcelColumn(value = "品类编码", order = 25)
    private String productCategoryCode;

    @CrmExcelColumn(value = "品类名称", order = 26)
    private String productCategoryName;

    @CrmExcelColumn(value = "品项编码", order = 27)
    private String productItemCode;

    @CrmExcelColumn(value = "品项名称", order = 28)
    private String productItemName;

    @CrmExcelColumn(value = "产品编码", order = 29)
    private String productCode;

    @CrmExcelColumn(value = "产品名称", order = 30)
    private String productName;

    @CrmExcelColumn(value = "总部统筹预算项目编码", order = 31)
    private String headBudgetItemCode;

    @CrmExcelColumn(value = "大区预算项目编码", order = 32)
    private String monthBudgetCode;

    @CrmExcelColumn(value = "形式说明", order = 33)
    private String specification;

    @CrmExcelColumn(value = "是否临时活动", order = 34)
    private String isTemporary;

    /**
     * 执行指标名称
     */
    @CrmExcelColumn(value = "*指标名称", order = 35)
    private String indicatorName;

    /**
     * 执行指标名称
     */
    @CrmExcelColumn(value = "*指标编码", order = 36)
    private String variableCode;

    /**
     * 指标值
     */
    @CrmExcelColumn(value = "*指标值(数字)", order = 37)
    private String indicatorValueStr;
    private BigDecimal indicatorValue;


    /**
     * 年月（yyyy-MM）
     */
    @ExcelIgnore
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearAndMonth;

    @ExcelIgnore
    @ApiModelProperty(value = "salesInstitutionName", name = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesInstitutionErpCode", name = "销售机构erp编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    private String salesRegionCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    private String salesRegionName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    private String salesRegionErpCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgCode", name = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgName", name = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgErpCode", name = "销售组织erp编码", notes = "销售组织erp编码")
    private String salesOrgErpCode;

    /**
     * 渠道名称
     */
    @ExcelIgnore
    private String channelName;

    /**
     * 客户名称
     */
    @ExcelIgnore
    private String customerName;

    /**
     * 客户erp编码
     */
    @ExcelIgnore
    private String customerErpCode;

    /**
     * 门店名称
     */
    @ExcelIgnore
    private String storesName;

    /**
     * 对接系统 (数据字典：tpm_indicator_system)
     */
    @ExcelIgnore
    private String dockingSystem;

    /**
     * 对接系统 (数据字典：tpm_indicator_system)
     */
    @ExcelIgnore
    private String id;

    @ApiModelProperty("人员编码")
    @ExcelIgnore
    private String personCode;
}
