package com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: hd
 * @description: 结案核销-执行指标表sap导入vo
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class AuditExecuteIndicatorSapImportVo extends CrmExcelVo {

    /**
     * 业态（数据字典：mdm_business_format）
     */
    @CrmExcelColumn(value = "*业态", order = 0)
    private String businessFormatCode;

    /**
     * 业务单元（数据字典：mdm_business_unit）
     */
    @CrmExcelColumn(value = "*业务单元", order = 1)
    private String businessUnitCode;

    /**
     * 年月（yyyy-MM）
     */
    @CrmExcelColumn(value = "*年月(例：2022-09)", order = 2)
    private String yearAndMonthStr;

    @CrmExcelColumn(value = "细案明细编码", order = 3)
    private String activeNumber;

    @CrmExcelColumn(value = "*指标名称", order = 4)
    private String indicatorName;

    @CrmExcelColumn(value = "*指标值(数字)", order = 5)
    private BigDecimal indicatorValue;

    @CrmExcelColumn(value = "*销售机构编码", order = 6)
    private String salesInstitutionCode;

    @CrmExcelColumn(value = "*客户编码", order = 7)
    private String customerCode;

    @CrmExcelColumn(value = "*客户名称", order = 8)
    private String customerName;

    @CrmExcelColumn(value = "区域名称", order = 9)
    private String regionName;

    @CrmExcelColumn(value = "零售商名称", order = 10)
    private String customerRetailerName;

    @CrmExcelColumn(value = "品牌编码", order = 11)
    private String productBrandCode;

    @CrmExcelColumn(value = "品类编码", order = 12)
    private String productCategoryCode;

    @CrmExcelColumn(value = "品项编码", order = 13)
    private String productItemCode;

    @CrmExcelColumn(value = "产品编码", order = 14)
    private String productCode;


    /**
     * 品牌名称
     */
    @ExcelIgnore
    @ApiModelProperty(name = "品牌名称", notes = "品牌名称")
    private String productBrandName;

    /**
     * 所属品类名称
     */
    @ExcelIgnore
    @ApiModelProperty(name = "所属品类名称", notes = "所属品类名称")
    private String productCategoryName;

    /**
     * 品项名称
     */
    @ExcelIgnore
    @ApiModelProperty(name = "品项名称", notes = "品项名称")
    private String productItemName;


    /**
     * 产品名称
     */
    @ExcelIgnore
    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    /**
     * 渠道编码
     */
    @ExcelIgnore
    private String channelCode;


    /**
     * 门店编码
     */
    @ExcelIgnore
    private String storesCode;

    /**
     * 人员类型
     */
    @ExcelIgnore
    private String personnelType;

    /**
     * 人员Id
     */
    @ExcelIgnore
    private String personnelId;


    /**
     * 执行指标名称
     */
    @ExcelIgnore
    private String variableCode;


    @ExcelIgnore
    private String personCode;

    @ExcelIgnore
    private String personName;

    @ExcelIgnore
    private String employeeTypeName;

    /**
     * 年月（yyyy-MM）
     */
    @ExcelIgnore
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearAndMonth;

    @ExcelIgnore
    @ApiModelProperty(value = "salesInstitutionName", name = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesInstitutionErpCode", name = "销售机构erp编码", notes = "销售机构erp编码")
    private String salesInstitutionErpCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionCode", name = "销售部门编码", notes = "销售部门编码")
    private String salesRegionCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionName", name = "销售部门名称", notes = "销售部门名称")
    private String salesRegionName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesRegionErpCode", name = "销售部门erp编码", notes = "销售部门erp编码")
    private String salesRegionErpCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgCode", name = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgName", name = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    @ExcelIgnore
    @ApiModelProperty(value = "salesOrgErpCode", name = "销售组织erp编码", notes = "销售组织erp编码")
    private String salesOrgErpCode;

    /**
     * 渠道名称
     */
    @ExcelIgnore
    private String channelName;


    /**
     * 客户erp编码
     */
    @ExcelIgnore
    private String customerErpCode;

    /**
     * 门店名称
     */
    @ExcelIgnore
    private String storesName;

    /**
     * 对接系统 (数据字典：tpm_indicator_system)
     */
    @ExcelIgnore
    private String dockingSystem;

    /**
     * 对接系统 (数据字典：tpm_indicator_system)
     */
    @ExcelIgnore
    private String id;

    @ExcelIgnore
    @ApiModelProperty("员工类型编码")
    private String employeeTypeCode;

    @ExcelIgnore
    @ApiModelProperty("所属大区编码")
    private String regionCode;

    @ExcelIgnore
    @ApiModelProperty(name = "所属零售商编码")
    private String customerRetailerCode;
    @ExcelIgnore
    private String indicatorCode;

    @ApiModelProperty(name = "活动类型编码", notes = "活动类型编码")
    @ExcelIgnore
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @ExcelIgnore
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @ExcelIgnore
    private String activityFormName;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @ExcelIgnore
    private String activityFormCode;

    @ApiModelProperty(name = "活动开始时间", notes = "活动开始时间")
    @ExcelIgnore
    private String activityBeginDate;

    @ApiModelProperty(name = "活动结束时间", notes = "活动结束时间")
    @ExcelIgnore
    private String activityEndDate;
}
