package com.biz.crm.tpm.business.variable.sdk.register;


import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 15:39
 * @description：公式变量注册器
 */
public interface FormulaVariableRegister {

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    String getVariableCode();

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    String getVariableName();

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    Integer getSort();

    /**
     * 是否可配置
     *
     * @return 是否可配置
     */
    default Boolean isConfigurable() {
        return Boolean.FALSE;
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    default List<String> getFunctionStringList() {
        List<VariableFunctionEnum> functionList = this.getFunctionEnumList();
        return VariableFunctionEnum.findCodeByEnums(functionList);
    }

    /**
     * 适用范围
     *
     * @return 适用范围
     */
    List<VariableFunctionEnum> getFunctionEnumList();

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto);


}
