package com.biz.crm.tpm.business.variable.sdk.register;


import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateWarningDto;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 预警非活动相关变量注册器，其他变量禁止实现
 * 实现本接口时必须！必须！必须！同时实现FormulaVariableRegister
 *
 * @author ：duyiran
 * @date ：2022/11/3 15:39
 */
public interface FormulaWarningVariableUsingRedisRegister {

    /**
     * 变量编码
     *
     * @return 变量编码
     */
    String getVariableCode();

    /**
     * 变量名称
     *
     * @return 变量名称
     */
    String getVariableName();

    /**
     * 变量排序
     *
     * @return 变量排序
     */
    Integer getSort();

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    Map<String, BigDecimal> calculateVariable(CalculateDto calculateDto);

    /**
     * 根据条件查询变量值，并上传至redis
     *
     * @param calculateDtoList 计算条件，（建议）service层无法明确变量需要哪些属性，实现此方法需对计算条件验重
     * @return 根据入参查询出具体执行预警的条件
     */
    List<CalculateWarningDto> upLoadWarningValuesToRedis(List<CalculateWarningDto> calculateDtoList);

    /**
     * 根据条件获取变量值
     *
     * @param calculateDto 计算条件
     * @return 根据条件获取变量值
     */
    Map<String, BigDecimal> calculateVariableUsingRedis(CalculateDto calculateDto);

}
