package com.biz.crm.tpm.business.variable.sdk.service;

import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * @Description 可配置变量明细接口
 * @Author YangWei
 * @Date Created in 2023/3/17 上午10:35
 */
public interface ConVariableDetailSdkService {

    /**
     * 删除明细
     * @param detailDto
     */
    default void deleteByAuditFormulaCode(ConVariableDetailDto detailDto){}

    /**
     * 保存明细
     * @param detailDto
     */
    default void batchSave(List<ConVariableDetailDto> detailDto){}

    /**
     * 获取明细
     * @param detailDto
     */
    default List<ConVariableDetailVo> getItemDetail(ConVariableDetailDto detailDto){
        return Lists.newArrayList();
    }

    /**
     * 通过核销公式编码查询可配置变量
     * @param codes
     * @return
     */
    List<ConVariableDetailVo> findConVariableListByCodes(List<String> codes);

    List<ConVariableDetailVo> findConVariableList(String formulaCode, String variableCode);
}