package com.biz.crm.tpm.business.variable.sdk.service;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.ControlsDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.variable.sdk.vo.ControlsVo;
import com.biz.crm.tpm.business.variable.sdk.vo.RegisterVariableVo;
import com.biz.crm.tpm.business.variable.sdk.vo.VariableCalTestVo;

import java.util.List;
import java.util.Map;

/**
 * 公式服务
 *
 * @author ：dengwei
 * @date ：Created in 2022/11/18 11:05
 */
public interface VariableService {

    /**
     * 获取变量列表
     *
     * @param isConfigure 是否可配置
     * @return 变量列表
     */
    List<RegisterVariableVo> variableList(String isConfigure, String function, String name, Integer pageSize);

    /**
     * 走关键指标表查询
     *
     * @param isConfigure 是否可配置
     * @param function    适用范围
     * @param name        名称
     * @param pageSize    查询限制条数
     * @return
     */
    List<RegisterVariableVo> variableAuthList(String isConfigure, String function, String name, Integer pageSize);

    /**
     * 计算所有条件&公式
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> allCalculateConditionAndExpression(List<CalculateDto> calculateDtoList);

    /**
     * 仅计算所有条件
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> allCalculateCondition(List<CalculateDto> calculateDtoList);

    /**
     * 计算所有公式
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> allCalculateExpression(List<CalculateDto> calculateDtoList);

    /**
     * 或计算条件&公式（一个CalculateDto只计算满足一条就返回）
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> orCalculateConditionAndExpression(List<CalculateDto> calculateDtoList);

    /**
     * 或计算条件（一个CalculateDto只计算满足一条就返回）
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> orCalculateCondition(List<CalculateDto> calculateDtoList);

    /**
     * 或计算公式（一个CalculateDto只计算满足一条就返回）
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> orCalculateExpression(List<CalculateDto> calculateDtoList);

    /**
     * 变量编码-名称映射
     *
     * @return
     */
    Map<String, String> getVariableMap(String function, List<String> variableCodeList);

    /**
     * 测试计算
     *
     * @param dto
     * @return
     */
    VariableCalTestVo calTest(CalculateDto dto);

    /**
     * 预算管控
     *
     * @param controlsDto
     * @return {@link DimensionControlsVo}
     */
    default ControlsVo overallControl(ControlsDto controlsDto) {
        return null;
    }

    /**
     * 测试公式配置是否合法
     *
     * @param formulaInfoList
     */
    void testFormula(List<FormulaInfoDto> formulaInfoList);
}
