package com.biz.crm.tpm.business.variable.sdk.service;

import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;

import java.util.List;

/**
 * 公式服务(使用redis做缓存，非大量数据同时取建议使用VariableService.onCalculate)
 * 目前该类只有预警在使用，其他功能请自行判断是否适用
 *
 * @author ：duyiran
 * @date ： 2022/12/09 15:05
 */
public interface VariableUsingRedisService {

    /**
     * 计算所有条件&公式
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> allCalculateConditionAndExpression(List<CalculateDto> calculateDtoList);

    /**
     * 仅计算所有条件
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> allCalculateCondition(List<CalculateDto> calculateDtoList);

    /**
     * 计算所有公式
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> allCalculateExpression(List<CalculateDto> calculateDtoList);

    /**
     * 或计算条件&公式（一个CalculateDto只计算满足一条就返回）
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> orCalculateConditionAndExpression(List<CalculateDto> calculateDtoList);

    /**
     * 或计算条件（一个CalculateDto只计算满足一条就返回）
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> orCalculateCondition(List<CalculateDto> calculateDtoList);

    /**
     * 或计算公式（一个CalculateDto只计算满足一条就返回）
     *
     * @param calculateDtoList 计算条件
     * @return 计算结果
     */
    List<CalculateVo> orCalculateExpression(List<CalculateDto> calculateDtoList);

}
