package com.biz.crm.tpm.business.variable.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 计算Vo
 *
 * @author ：dengwei
 * @date ：Created in 2022/11/3 14:08
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CalculateVo", description = "计算Vo")
public class CalculateVo extends TenantFlagOpVo {

    /***************************公用***********************/

    @ApiModelProperty("唯一编码")
    private String code;

    @ApiModelProperty("公式条件（展示用）")
    private String formulaConditionName;

    @ApiModelProperty("公式条件（值）")
    private Boolean formulaConditionValue;

    @ApiModelProperty("公式（展示用）")
    private String formulaName;

    @ApiModelProperty("公式（值）")
    private BigDecimal formulaValue;

    @ApiModelProperty("公式内所有变量及其值")
    private Map<String, BigDecimal> variableValueMap;

    /***************************预警***********************/

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    private String activityFormCode;

    @ApiModelProperty("客户编码")
    private String customerName;

    @ApiModelProperty("产品编码")
    private String productName;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "预警级别[数据字典:tpm_warning_level]", notes = "预警级别[数据字典:tpm_warning_level]")
    private String warningLevel;

}
