package com.biz.crm.tpm.business.variable.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description
 * @Author YangWei
 * @Date 2023/3/17 上午10:39
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "可配置变量明细")
public class ConVariableDetailVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;

    @ApiModelProperty(name = "配置变量编码code", notes = "配置变量编码code")
    private String variableCode;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "开始时间", notes = "开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(name = "结束时间", notes = "结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(name = "summaryDimension",value = "汇总维度", notes = "汇总维度")
    private String summaryDimension;

    @ApiModelProperty(name = "itemType",value = "条件类型", notes = "条件类型")
    private String itemType;

    @ApiModelProperty(name = "itemCode",value = "条件编码", notes = "条件编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName",value = "条件名称", notes = "条件名称")
    private String itemName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "productBrandCode",value = "品牌编码", notes = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "productBrandName",value = "品牌名称", notes = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "productCategoryCode",value = "品类编码", notes = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "productCategoryName",value = "品类名称", notes = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(name = "productItemCode",value = "品项编码", notes = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(name = "productItemName",value = "品项名称", notes = "品项名称")
    private String productItemName;

    /**
     * 点数
     */
    @ApiModelProperty("点数")
    private BigDecimal point;
}