package com.biz.crm.tpm.business.variable.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 16:55
 * @description：注册的变量Vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "RegisterVariableVo", description = "注册的变量Vo")
public class RegisterVariableVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(value = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "varchar(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty("变量code")
    private String code;

    @ApiModelProperty("变量名称")
    private String name;

    @ApiModelProperty("变量类型")
    private String type;

    @ApiModelProperty("排序")
    private Integer sort;

}
