package com.biz.crm.tpm.business.withholding.formula.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.withholding.formula.feign.feign.impl.WithholdingFormulaFeignImpl;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/1 20:51
 * @description：商务政策
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = WithholdingFormulaFeignImpl.class)
public interface WithholdingFormulaFeign {

    @PostMapping("/v1/withholdingFormulaMain/findForWithholdingDetail")
    Result<List<WithholdingFormulaMainVo>> findForWithholdingDetail(@RequestBody WithholdingFormulaMainDto dto);
}
