package com.biz.crm.tpm.business.withholding.formula.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaSelectDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.service.WithholdingFormulaMainService;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 预提公式主表(WithholdingFormulaMain)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-03 20:07:04
 */
@RestController
@RequestMapping("/v1/withholdingFormulaMain")
@Slf4j
@Api(tags = "预提公式主表")
public class WithholdingFormulaMainController {
  /**
  * 服务对象
  */
  @Autowired
  private WithholdingFormulaMainService withholdingFormulaMainService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param withholdingFormulaMain 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<WithholdingFormulaMainVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "withholdingFormulaMain", value = "预提公式主表") WithholdingFormulaMainDto withholdingFormulaMain) {
    try {
      Page<WithholdingFormulaMainVo> page =  this.withholdingFormulaMainService.findByConditions(pageable,withholdingFormulaMain);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<WithholdingFormulaMainVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      WithholdingFormulaMainVo withholdingFormulaMain = this.withholdingFormulaMainService.findById(id);
      return Result.ok(withholdingFormulaMain);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param withholdingFormulaMain 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<?> create(@ApiParam(name = "withholdingFormulaMain", value = "预提公式主表") @RequestBody WithholdingFormulaMainDto withholdingFormulaMain) {
    try {
      this.withholdingFormulaMainService.create(withholdingFormulaMain);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 修改数据
   *
   * @param withholdingFormulaMain 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<?> update(@ApiParam(name = "withholdingFormulaMain", value = "预提公式主表") @RequestBody WithholdingFormulaMainDto withholdingFormulaMain) {
    try {
      this.withholdingFormulaMainService.update(withholdingFormulaMain);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "id", value = "主键集合") @RequestParam("id") List<String> idList) {
    try {
      this.withholdingFormulaMainService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PatchMapping("enable")
  public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.withholdingFormulaMainService.enable(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PatchMapping("disable")
  public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.withholdingFormulaMainService.disable(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @GetMapping("getWithholdingFormulaByWithholdingType")
  public Result<?> getWithholdingFormulaByWithholdingType(@RequestParam("withholdingType") String withholdingType){
    try {
      return Result.ok(this.withholdingFormulaMainService.getWithholdingFormulaByWithholdingType(withholdingType));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PostMapping("findForWithholdingDetail")
  public Result<List<WithholdingFormulaMainVo>> findForWithholdingDetail(@RequestBody WithholdingFormulaMainDto dto){
    try {
      return Result.ok(this.withholdingFormulaMainService.findForWithholdingDetail(dto));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "预提规则-汇总规则下拉参数dto")
  @PostMapping("getSummaryFormulaSelect")
  public Result<List<CommonSelectVo>> getSummaryFormulaSelect(@ApiParam(value = "预提规则-汇总规则下拉参数dto") @RequestBody WithholdingFormulaSelectDto dto) {
    try {
      List<CommonSelectVo> list = withholdingFormulaMainService.getSummaryFormulaSelect(dto);
      return Result.ok(list);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
