package com.biz.crm.tpm.business.withholding.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 17:53
 * @description：预提公式表
 */
@ApiModel(value = "WithholdingFormulaInfo", description = "预提公式表")
@TableName("tpm_withholding_formula_info")
@Getter
@Setter
@Entity(name = "tpm_withholding_formula_info")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_formula_info", comment = "预提公式表")
@Table(name = "tpm_withholding_formula_info")
public class WithholdingFormulaInfo extends TenantEntity {

    @ApiModelProperty(name = "预提公式编码", notes = "预提code")
    @Column(name = "withholding_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提公式编码'")
    private String withholdingFormulaCode;

    @Column(name = "withholding_formula_condition" ,   columnDefinition = "VARCHAR(500) COMMENT '预提公式条件'")
    @ApiModelProperty("预提公式条件")
    private String withholdingFormulaCondition;

    @Column(name = "withholding_formula_condition_name" ,   columnDefinition = "VARCHAR(500) COMMENT '预提公式条件（展示用）'")
    @ApiModelProperty("预提公式条件（展示用）")
    private String withholdingFormulaConditionName;

    @Column(name = "withholding_formula" ,   columnDefinition = "VARCHAR(500) COMMENT '预提公式'")
    @ApiModelProperty("预提公式")
    private String withholdingFormula;

    @Column(name = "withholding_formula_name" ,   columnDefinition = "VARCHAR(500) COMMENT '预提公式（展示用）'")
    @ApiModelProperty("预提公式（展示用）")
    private String withholdingFormulaName;
}
