package com.biz.crm.tpm.business.withholding.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 17:52
 * @description：预提公式主表
 */
@ApiModel(value = "WithholdingFormulaMain", description = "预提公式主表")
@TableName("tpm_withholding_formula_main")
@Getter
@Setter
@Entity(name = "tpm_withholding_formula_main")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_formula_main", comment = "预提公式主表")
@Table(name = "tpm_withholding_formula_main")
public class WithholdingFormulaMain extends TenantFlagOpEntity {

    @ApiModelProperty(name = "预提规则编码", notes = "预提规则编码")
    @Column(name = "withholding_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提规则编码'")
    private String withholdingFormulaCode;

    @ApiModelProperty(name = "预提规则名称", notes = "预提规则名称")
    @Column(name = "withholding_formula_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提规则名称'")
    private String withholdingFormulaName;

    @ApiModelProperty(name = "预提规则类型", notes = "预提规则类型")
    @Column(name = "withholding_type",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提规则类型'")
    private String withholdingType;

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "销售组织", notes = "销售组织")
    @Column(name = "sales_org_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "开始年月", notes = "开始年月")
    @Column(name = "begin_year_and_month",  length = 20, columnDefinition = "VARCHAR(20) COMMENT '开始年月'")
    private String beginYearAndMonth;

    @ApiModelProperty(name = "结束年月", notes = "结束年月")
    @Column(name = "end_year_and_month",  length = 20, columnDefinition = "VARCHAR(20) COMMENT '结束年月'")
    private String endYearAndMonth;

    @ApiModelProperty(name = "销售部门", notes = "销售部门")
    @Column(name = "sale_department_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售部门'")
    private String saleDepartmentCode;

    @ApiModelProperty(name = "销售部门名称", notes = "销售部门名称")
    @Column(name = "sale_department_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
    private String saleDepartmentName;

    @ApiModelProperty(name = "平台", notes = "平台")
    @Column(name = "platform_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '平台'")
    private String platformCode;

    @ApiModelProperty(name = "平台名称", notes = "平台名称")
    @Column(name = "platform_name",  length = 128, columnDefinition = "VARCHAR(256) COMMENT '平台'")
    private String platformName;

    @ApiModelProperty(name = "客户", notes = "客户")
    @Column(name = "customer_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户'")
    private String customerCode;

    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "电商渠道", notes = "电商渠道")
    @Column(name = "e_commerce_channel_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '电商渠道'")
    private String eCommerceChannelCode;

    @ApiModelProperty(name = "电商渠道名称", notes = "电商渠道名称")
    @Column(name = "e_commerce_channel_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '电商渠道名称'")
    private String eCommerceChannelName;

    @ApiModelProperty(name = "生效活动形式", notes = "生效活动形式")
    @Column(name = "effective_activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '生效活动形式'")
    private String effectiveActivityFormCode;

    @ApiModelProperty(name = "生效活动形式名称", notes = "生效活动形式名称")
    @Column(name = "effective_activity_form_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '生效活动形式名称'")
    private String effectiveActivityFormName;

    @ApiModelProperty(name = "是否按成本中心", notes = "是否按成本中心")
    @Column(name = "is_cost_center",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按成本中心'")
    private String isCostCenter;

    @ApiModelProperty(name = "是否按预算项目", notes = "是否按预算项目")
    @Column(name = "is_budget_project",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按预算项目'")
    private String isBudgetProject;

    @ApiModelProperty(name = "是否按会计科目", notes = "是否按会计科目")
    @Column(name = "is_accountant_subject",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按会计科目'")
    private String isAccountantSubject;

    @ApiModelProperty(name = "预提科目", notes = "预提科目")
    @Column(name = "withholding_subject",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '预提科目'")
    private String withholdingSubject;

    @ApiModelProperty(name = "是否按客户", notes = "是否按客户")
    @Column(name = "is_from_customer",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按客户'")
    private String isFromCustomer;

    @ApiModelProperty(name = "是否按部门", notes = "是否按部门")
    @Column(name = "is_from_department",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否按部门'")
    private String isFromDepartment;

    @ApiModelProperty("销售机构复选")
    @Column(name = "sale_org_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '销售机构复选'")
    private String saleOrgCb;

    @ApiModelProperty("销售部门复选")
    @Column(name = "sale_org_department_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '销售部门复选'")
    private String saleOrgDepartmentCb;

    @ApiModelProperty("销售组复选")
    @Column(name = "sale_group_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '销售组复选'")
    private String saleGroupCb;

    @ApiModelProperty("客户复选")
    @Column(name = "customer_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '客户复选'")
    private String customerCb;

    @ApiModelProperty("活动形式复选")
    @Column(name = "activity_form_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '活动形式复选'")
    private String activityFormCb;

    /***2023-03-24 1022483垂直需求**/

    @ApiModelProperty("零售商复选")
    @Column(name = "system_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '零售商复选'")
    private String systemCb;

    @ApiModelProperty("区域复选")
    @Column(name = "region_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '区域复选'")
    private String regionCb;

    @ApiModelProperty("费用中心复选")
    @Column(name = "fee_center_cb",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '费用中心复选'")
    private String feeCenterCb;

    @ApiModelProperty("是否区分活动类型")
    @Column(name = "diff_activity_type",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否区分活动类型'")
    private String diffActivityType;

    @ApiModelProperty(value = "合同编号", notes = "")
    @Column(name = "contract_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合同编号'")
    private String contractCode;

    @ApiModelProperty(value = "合同名称", notes = "")
    @Column(name = "contract_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '合同名称'")
    private String contractName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;
}
