package com.biz.crm.tpm.business.withholding.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Getter
@Setter
@ApiModel(value = "WithholdingFormulaROrgEntity", description = "预提规则关联销售组织表")
@TableName("tpm_withholding_formula_r_org")
@Entity(name = "tpm_withholding_formula_r_org")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_formula_r_org", comment = "预提规则关联销售组织表")
@Table(name = "tpm_withholding_formula_r_org")
public class WithholdingFormulaROrgEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "预提规则编码", notes = "预提规则编码")
    @Column(name = "withholding_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提规则编码'")
    private String withholdingFormulaCode;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty("销售组织ERP编码")
    @Column(name = "sales_org_erp_code", length = 64, columnDefinition = " varchar(64) COMMENT '销售组织编码'")
    private String salesOrgErpCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sale_org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String saleOrgName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;
}
