package com.biz.crm.tpm.business.withholding.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @ClassName WithholdingFormulaRProductEntity
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/26
 */
@Data
@ApiModel(value = "WithholdingFormulaRProductEntity", description = "预提规则关联产品表")
@TableName("tpm_withholding_formula_r_product")
@Entity(name = "tpm_withholding_formula_r_product")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_formula_r_product", comment = "预提规则关联产品表")
@Table(name = "tpm_withholding_formula_r_product")
public class WithholdingFormulaRProductEntity extends TenantFlagOpEntity {

    @ApiModelProperty("关联预提规则编码")
    @TableField(value = "withholding_formula_code")
    @Column(name = "withholding_formula_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联预提规则编码'")
    private String withholdingFormulaCode;

    @ApiModelProperty("商品编码")
    @TableField(value = "product_code")
    @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品名称")
    @TableField(value = "product_name")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty("产品品牌编码")
    @TableField(value = "product_brand_code")
    @Column(name = "product_brand_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品品牌编码'")
    private String productBrandCode;

    @ApiModelProperty("产品品牌名称")
    @TableField(value = "product_brand_name")
    @Column(name = "product_brand_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '产品品牌名称'")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(64) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty("产品层级编码（品相编码）")
    @TableField(value = "product_level_code")
    @Column(name = "product_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '产品层级编码（品相编码）'")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称（品相名称）")
    @TableField(value = "product_level_name")
    @Column(name = "product_level_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '产品层级名称（品相名称）'")
    private String productLevelName;

    @ApiModelProperty("产品覆盖范围类型[product_cover_type]")
    @TableField(value = "product_cover_type")
    @Column(name = "product_cover_type", nullable = true, length = 40, columnDefinition = "VARCHAR(40) COMMENT '产品覆盖范围类型[product_cover_type]'")
    private String productCoverType;

}
