package com.biz.crm.tpm.business.withholding.formula.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaMain;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaSelectDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 预提公式主表(WithholdingFormulaMain)表mybatis访问层
 *
 * @author makejava
 * @since 2022-11-03 20:07:08
 */
public interface WithholdingFormulaMainMapper extends BaseMapper<WithholdingFormulaMain> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param withholdingFormulaMain 查询实体
   * @return 所有数据
  */
  public Page<WithholdingFormulaMainVo> findByConditions(@Param("page") Page<WithholdingFormulaMainVo> page, @Param("withholdingFormulaMain") WithholdingFormulaMainDto withholdingFormulaMain);

  /**
   * 根据预提类型获取预提规则
   * @param withholdingType
   * @param currentYearMonth
   * @author jiangyin
   * @date 2023/1/9 11:34
   * @return java.util.List<com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo>
   */
  List<WithholdingFormulaMainVo> getWithholdingFormulaByWithholdingType(@Param("withholdingType") String withholdingType, @Param("yearMonth") String currentYearMonth);

  List<WithholdingFormulaMainVo> findForWithholdingDetail(@Param("yearMonth") String yearMonth, @Param("dto") WithholdingFormulaMainDto dto);

  List<CommonSelectVo> getSummaryFormulaSelect(@Param("dto") WithholdingFormulaSelectDto dto, @Param("limitSize") int limitSize);
}

