package com.biz.crm.tpm.business.withholding.formula.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/9 10:16
 * @description：预提公式
 */
@Component
@Slf4j
public class WithholdingFormulaRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_withholding_formula_main_data_view";
    }

    @Override
    public String desc() {
        return "TPM-预提公式";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_withholding_formula_main t " +
                " where t.tenant_code = :tenantCode " +
                " and t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
