package com.biz.crm.tpm.business.withholding.formula.local.repository;



import com.biz.crm.tpm.business.withholding.formula.local.entity.WithholdingFormulaInfo;
import com.biz.crm.tpm.business.withholding.formula.local.mapper.WithholdingFormulaInfoMapper;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaInfoVo;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 预提公式表(WithholdingFormulaInfo)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 20:07:08
 */
@Component
public class WithholdingFormulaInfoRepository extends ServiceImpl<WithholdingFormulaInfoMapper, WithholdingFormulaInfo> {

  @Autowired
  private WithholdingFormulaInfoMapper withholdingFormulaInfoMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param withholdingFormulaInfo 实体对象
   * @return
   */
  public Page<WithholdingFormulaInfo> findByConditions(Pageable pageable, WithholdingFormulaInfo withholdingFormulaInfo) {
    Page<WithholdingFormulaInfo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<WithholdingFormulaInfo> pageList = this.withholdingFormulaInfoMapper.findByConditions(page, withholdingFormulaInfo);
    return pageList;
  }

  public List<WithholdingFormulaInfoVo> findInfoByMainCodeList(List<String> mainCodeList) {
    return withholdingFormulaInfoMapper.findInfoByMainCodeList(mainCodeList);
  }
}

